/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.api;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.chromattic.api.BuilderException;
import org.chromattic.api.Chromattic;
import org.chromattic.api.ChromatticBuilder;
import org.chromattic.api.format.ObjectFormatter;
import org.chromattic.common.ObjectInstantiator;
import org.chromattic.common.jcr.Path;
import org.chromattic.common.jcr.PathException;
import org.chromattic.core.Domain;
import org.chromattic.core.api.ChromatticImpl;
import org.chromattic.core.mapper.MapperBuilder;
import org.chromattic.core.mapper.ObjectMapper;
import org.chromattic.metamodel.mapping.BeanMapping;
import org.chromattic.metamodel.mapping.BeanMappingBuilder;
import org.chromattic.metamodel.type.SimpleTypeResolver;
import org.chromattic.spi.instrument.Instrumentor;
import org.chromattic.spi.jcr.SessionLifeCycle;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.TypeResolver;
import org.reflext.core.TypeResolverImpl;
import org.reflext.jlr.JavaLangReflectReflectionModel;
import org.reflext.spi.model.ReflectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChromatticBuilderImpl
extends ChromatticBuilder {
    private Collection<ObjectMapper<?>> mappers;

    private <T> T create(ChromatticBuilder.Option.Instance<String> optionInstance, Class<T> expectedClass) {
        String s = (String)optionInstance.getValue();
        return (T)ObjectInstantiator.newInstance((String)s, expectedClass);
    }

    protected void init(Set<Class<?>> classes) throws BuilderException {
        SimpleTypeResolver propertyTypeResolver = new SimpleTypeResolver();
        TypeResolver typeResolver = TypeResolverImpl.create((ReflectionModel)JavaLangReflectReflectionModel.getInstance());
        HashSet<ClassTypeInfo> classTypes = new HashSet<ClassTypeInfo>();
        for (Class<?> clazz : classes) {
            ClassTypeInfo typeInfo = (ClassTypeInfo)typeResolver.resolve(clazz);
            classTypes.add(typeInfo);
        }
        Map beanMappings = new BeanMappingBuilder().build(classTypes);
        Collection<BeanMapping> mappings = beanMappings.values();
        MapperBuilder builder = new MapperBuilder(propertyTypeResolver);
        Collection<ObjectMapper<?>> mappers = builder.build(mappings);
        this.mappers = mappers;
    }

    protected Chromattic boot(ChromatticBuilder.Configuration options) throws BuilderException {
        boolean lazyCreateMode;
        String rootNodePath;
        Boolean optimizeJCREnabled = (Boolean)options.getOptionValue(JCR_OPTIMIZE_ENABLED);
        boolean hasPropertyOptimized = optimizeJCREnabled != null ? optimizeJCREnabled.booleanValue() : ((Boolean)options.getOptionValue(JCR_OPTIMIZE_HAS_PROPERTY_ENABLED)).booleanValue();
        boolean hasNodeOptimized = optimizeJCREnabled != null ? optimizeJCREnabled.booleanValue() : ((Boolean)options.getOptionValue(JCR_OPTIMIZE_HAS_NODE_ENABLED)).booleanValue();
        try {
            rootNodePath = Path.normalizeAbsolutePath((String)((String)options.getOptionValue(ROOT_NODE_PATH)));
        }
        catch (PathException e) {
            throw new BuilderException("Root node path must be valid");
        }
        int rootCreateMode = ((Boolean)options.getOptionValue(CREATE_ROOT_NODE)).booleanValue() ? ((lazyCreateMode = ((Boolean)options.getOptionValue(LAZY_CREATE_ROOT_NODE)).booleanValue()) ? Domain.LAZY_CREATE_MODE : Domain.CREATE_MODE) : Domain.NO_CREATE_MODE;
        String rootNodeType = (String)options.getOptionValue(ROOT_NODE_TYPE);
        boolean propertyCacheEnabled = (Boolean)options.getOptionValue(PROPERTY_CACHE_ENABLED);
        boolean propertyReadAheadEnabled = (Boolean)options.getOptionValue(PROPERTY_READ_AHEAD_ENABLED);
        Instrumentor instrumentor = this.create((ChromatticBuilder.Option.Instance<String>)options.getOptionInstance(INSTRUMENTOR_CLASSNAME), Instrumentor.class);
        ObjectFormatter objectFormatter = this.create((ChromatticBuilder.Option.Instance<String>)options.getOptionInstance(OBJECT_FORMATTER_CLASSNAME), ObjectFormatter.class);
        SessionLifeCycle sessionLifeCycle = this.create((ChromatticBuilder.Option.Instance<String>)options.getOptionInstance(SESSION_LIFECYCLE_CLASSNAME), SessionLifeCycle.class);
        Domain domain = new Domain(this.mappers, instrumentor, objectFormatter, propertyCacheEnabled, propertyReadAheadEnabled, hasPropertyOptimized, hasNodeOptimized, rootNodePath, rootCreateMode, rootNodeType);
        return new ChromatticImpl(domain, sessionLifeCycle);
    }
}

