/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.audit;

import javax.jcr.Item;
import javax.jcr.Node;
import org.apache.commons.chain.Context;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.command.action.Action;
import org.exoplatform.services.jcr.ext.audit.AuditService;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.observation.ExtendedEventType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AddAuditableAction
implements Action {
    private final Log log = ExoLogger.getLogger((String)"jcr.AddAuditableAction");

    public boolean execute(Context ctx) throws Exception {
        ItemImpl item = (ItemImpl)ctx.get((Object)"currentItem");
        int event = (Integer)ctx.get((Object)"event");
        Object node = item.isNode() ? (Node)item : item.getParent();
        AuditService auditService = (AuditService)((ExoContainer)ctx.get((Object)"exocontainer")).getComponentInstanceOfType(AuditService.class);
        if (node.canAddMixin("exo:auditable")) {
            node.addMixin("exo:auditable");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("exo:auditable adedd for " + node.getPath()));
            }
        }
        if (node.isNodeType("exo:auditable")) {
            if (!auditService.hasHistory((Node)node)) {
                auditService.createHistory((Node)node);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Audit history created for " + node.getPath()));
                }
            }
            auditService.addRecord((Item)item, event);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Record '" + ExtendedEventType.nameFromValue((int)event) + "' added for " + item.getPath()));
            }
            return true;
        }
        return false;
    }
}

