/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.integration.jbossas.vfs;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import org.jboss.seam.deployment.AbstractScanner;
import org.jboss.seam.deployment.DeploymentStrategy;
import org.jboss.seam.integration.jbossas.vfs.FileModifiableResource;
import org.jboss.seam.integration.jbossas.vfs.LeafVirtualFileFilter;
import org.jboss.seam.integration.jbossas.vfs.ModifiableResource;
import org.jboss.seam.integration.jbossas.vfs.VirtualFileModifiableResource;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.spi.registry.VFSRegistry;

public class VFSScanner
extends AbstractScanner {
    protected final LogProvider log = Logging.getLogProvider(((Object)((Object)this)).getClass());
    protected static Method handleMethod;
    private long timestamp;

    public VFSScanner(DeploymentStrategy deploymentStrategy) {
        super(deploymentStrategy);
    }

    protected VirtualFile getRoot(URL url, int parentDepth) throws IOException {
        String relative;
        this.log.trace((Object)("Root url: " + url));
        VFSRegistry registry = VFSRegistry.getInstance();
        VirtualFile vf = registry.getFile(url);
        for (int depth = parentDepth; vf != null && depth > 0; vf = vf.getParent(), --depth) {
        }
        if (vf != null) {
            return vf;
        }
        String urlString = url.toExternalForm();
        int p = urlString.indexOf(":");
        String file = urlString.substring(p + 1);
        URL vfsurl = null;
        File fp = new File(file);
        this.log.trace((Object)("File: " + fp));
        if (fp.exists()) {
            vfsurl = fp.getParentFile().toURL();
            relative = fp.getName();
        } else {
            File curr = fp;
            relative = fp.getName();
            while ((curr = curr.getParentFile()) != null) {
                if (curr.exists()) {
                    vfsurl = curr.toURL();
                    break;
                }
                relative = curr.getName() + "/" + relative;
            }
        }
        this.log.trace((Object)("URL: " + vfsurl + ", relative: " + relative));
        VirtualFile top = VFS.createNewRoot((URL)vfsurl);
        top = top.getChild(relative);
        while (parentDepth > 0) {
            if (top == null) {
                throw new IllegalArgumentException("Null parent: " + vfsurl + ", relative: " + relative);
            }
            top = top.getParent();
            --parentDepth;
        }
        this.log.trace((Object)("Top: " + top));
        return top;
    }

    public void scanDirectories(File[] directories) {
        this.scanDirectories(directories, new File[0]);
    }

    public void scanDirectories(File[] directories, File[] excludedDirectories) {
        for (File directory : directories) {
            this.handleDirectory(directory, null, excludedDirectories);
        }
    }

    private void handleDirectory(File file, String path, File[] excludedDirectories) {
        for (File excludedDirectory : excludedDirectories) {
            if (!file.equals(excludedDirectory)) continue;
            this.log.trace((Object)("Skipping excluded directory: " + file));
            return;
        }
        FileModifiableResource delegate = new FileModifiableResource();
        this.log.trace((Object)("Handling directory: " + file));
        for (File child : file.listFiles()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath, excludedDirectories);
                continue;
            }
            delegate.setFile(child);
            try {
                this.handleItem(delegate, newPath);
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }

    public void scanResources(String[] resources) {
        for (String resourceName : resources) {
            try {
                Enumeration<URL> urlEnum = this.getDeploymentStrategy().getClassLoader().getResources(resourceName);
                while (urlEnum.hasMoreElements()) {
                    URL url = urlEnum.nextElement();
                    VirtualFile root = this.getRoot(url, resourceName.lastIndexOf(47) > 0 ? 2 : 1);
                    if (root != null) {
                        this.handleRoot(root);
                        continue;
                    }
                    this.log.trace((Object)("Null root: " + url));
                }
            }
            catch (IOException ioe) {
                this.log.warn((Object)("Cannot read resource: " + resourceName), (Throwable)ioe);
            }
        }
    }

    protected void handleRoot(VirtualFile root) throws IOException {
        VirtualFileModifiableResource delegate = new VirtualFileModifiableResource();
        if (root.isLeaf()) {
            delegate.setFile(root);
            this.touchTimestamp(delegate);
            this.handleItemIgnoreErrors(root.getPathName());
        } else {
            boolean isArchive = root.isArchive();
            String rootPathName = root.getPathName();
            int rootPathNameLength = rootPathName.length();
            List children = root.getChildrenRecursively(LeafVirtualFileFilter.INSTANCE);
            for (VirtualFile child : children) {
                int length;
                String name = child.getPathName();
                if (name.charAt(length = rootPathNameLength) == '/') {
                    ++length;
                }
                String path = name.substring(length);
                if (isArchive) {
                    this.handleItemIgnoreErrors(path);
                    continue;
                }
                delegate.setFile(child);
                this.handleItem(delegate, path);
            }
        }
    }

    protected void handleItem(ModifiableResource resource, String name) throws IOException {
        boolean doTouch = true;
        try {
            if (handleMethod != null) {
                doTouch = (Boolean)handleMethod.invoke((Object)this, name);
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        if (doTouch) {
            this.touchTimestamp(resource);
        }
        if (handleMethod == null) {
            this.handleItemIgnoreErrors(name);
        }
    }

    protected void handleItemIgnoreErrors(String name) {
        try {
            this.handleItem(name);
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error handling item '" + name + "': " + t));
        }
    }

    private void touchTimestamp(ModifiableResource file) throws IOException {
        long lastModified = file.getLastModified();
        if (lastModified > this.timestamp) {
            this.timestamp = lastModified;
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    static {
        try {
            handleMethod = AbstractScanner.class.getDeclaredMethod("handle", String.class);
            handleMethod.setAccessible(true);
        }
        catch (Throwable t) {
            handleMethod = null;
        }
    }
}

