/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.integration.deployer.metadata;

import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.classloading.spi.metadata.ExportAll;
import org.jboss.classloading.spi.version.Version;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.virtual.VirtualFile;
import org.jboss.webbeans.integration.deployer.metadata.WebBeansAwareMetadataDeployer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebBeansClassloadingDeployer<T>
extends WebBeansAwareMetadataDeployer<T> {
    private boolean isolated = true;

    public WebBeansClassloadingDeployer(Class<T> input) {
        super(input);
        this.addInput(ClassLoadingMetaData.class);
        this.addOutput(ClassLoadingMetaData.class);
    }

    @Override
    protected void internalDeploy(VFSDeploymentUnit unit, T deployment, VirtualFile wbXml) throws DeploymentException {
        ClassLoadingMetaData classLoadingMetaData = (ClassLoadingMetaData)unit.getAttachment(ClassLoadingMetaData.class);
        if (classLoadingMetaData != null) {
            return;
        }
        if (this.isClassLoadingMetadataPresent(deployment)) {
            return;
        }
        if (!this.isIsolated(unit, wbXml)) {
            return;
        }
        String domain = this.getJMXName(deployment, (DeploymentUnit)unit) + ",extension=LoaderRepository";
        classLoadingMetaData = new ClassLoadingMetaData();
        classLoadingMetaData.setName(unit.getName());
        classLoadingMetaData.setDomain(domain);
        classLoadingMetaData.setExportAll(ExportAll.NON_EMPTY);
        classLoadingMetaData.setImportAll(true);
        classLoadingMetaData.setVersion((Object)Version.DEFAULT_VERSION);
        classLoadingMetaData.setJ2seClassLoadingCompliance(false);
        unit.addAttachment(ClassLoadingMetaData.class, (Object)classLoadingMetaData);
    }

    protected abstract boolean isClassLoadingMetadataPresent(T var1);

    protected boolean isIsolated(VFSDeploymentUnit unit, VirtualFile wbXml) {
        return this.isIsolated();
    }

    protected abstract String getJMXName(T var1, DeploymentUnit var2);

    public boolean isIsolated() {
        return this.isolated;
    }

    public void setIsolated(boolean isolated) {
        this.isolated = isolated;
    }
}

