/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.jsf;

import java.lang.annotation.Annotation;
import javax.context.Conversation;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpSession;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.context.ConversationContext;
import org.jboss.webbeans.conversation.ConversationManager;
import org.jboss.webbeans.jsf.PhaseHelper;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.servlet.ConversationBeanStore;
import org.jboss.webbeans.servlet.HttpSessionManager;

public class WebBeansPhaseListener
implements PhaseListener {
    private static LogProvider log = Logging.getLogProvider(WebBeansPhaseListener.class);

    public void beforePhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId().equals(PhaseId.RENDER_RESPONSE)) {
            this.beforeRenderReponse();
        }
    }

    private void beforeRenderReponse() {
        log.trace((Object)"In before render response phase");
        Conversation conversation = CurrentManager.rootManager().getInstanceByType(Conversation.class, new Annotation[0]);
        if (conversation.isLongRunning()) {
            PhaseHelper.propagateConversation(conversation.getId());
        } else {
            PhaseHelper.stopConversationPropagation();
        }
    }

    public void afterPhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId().equals(PhaseId.RESTORE_VIEW)) {
            this.afterRestoreView();
        } else if (phaseEvent.getPhaseId().equals(PhaseId.RENDER_RESPONSE)) {
            this.afterRenderResponse();
        }
        if (phaseEvent.getFacesContext().getResponseComplete()) {
            this.afterResponseComplete();
        }
    }

    private void afterResponseComplete() {
        log.trace((Object)"Post-response complete");
        CurrentManager.rootManager().getInstanceByType(ConversationManager.class, new Annotation[0]).cleanupConversation();
    }

    private void afterRestoreView() {
        log.trace((Object)"In after restore view phase");
        HttpSession session = PhaseHelper.getHttpSession();
        CurrentManager.rootManager().getInstanceByType(HttpSessionManager.class, new Annotation[0]).setSession(session);
        CurrentManager.rootManager().getInstanceByType(ConversationManager.class, new Annotation[0]).beginOrRestoreConversation(PhaseHelper.getConversationId());
        String cid = CurrentManager.rootManager().getInstanceByType(Conversation.class, new Annotation[0]).getId();
        ConversationContext.instance().setBeanStore(new ConversationBeanStore(session, cid));
        ConversationContext.instance().setActive(true);
    }

    private void afterRenderResponse() {
        log.trace((Object)"In after render reponse phase");
        CurrentManager.rootManager().getInstanceByType(ConversationManager.class, new Annotation[0]).cleanupConversation();
        ConversationContext.instance().setActive(false);
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

