/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.info.plugins;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.info.plugins.AbstractBeanInfo;
import org.jboss.beans.info.plugins.FieldFilter;
import org.jboss.beans.info.plugins.FieldPropertyInfo;
import org.jboss.beans.info.plugins.GetterAndFieldPropertyInfo;
import org.jboss.beans.info.plugins.SetterAndFieldPropertyInfo;
import org.jboss.beans.info.spi.BeanInfoFactory;
import org.jboss.beans.info.spi.EventInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.classadapter.spi.ClassAdapter;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.MethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldBeanInfo
extends AbstractBeanInfo {
    protected Map<String, FieldInfo> fieldsByName;

    public FieldBeanInfo(BeanInfoFactory beanInfoFactory, ClassAdapter classAdapter, Set<PropertyInfo> properties, Set<ConstructorInfo> constructors, Set<MethodInfo> methods, Set<EventInfo> events) {
        super(beanInfoFactory, classAdapter, properties, constructors, methods, events);
    }

    @Override
    public void setProperties(Set<PropertyInfo> properties) {
        this.setFields(FieldBeanInfo.getFields(this.classAdapter.getClassInfo(), this.getFieldFilter()));
        super.setProperties(properties);
        for (FieldInfo field : this.fieldsByName.values()) {
            PropertyInfo previous = this.findPropertyInfo(field.getName());
            if (previous != null && previous.getType().isAssignableFrom(field.getType())) continue;
            this.addProperty(new FieldPropertyInfo(field));
        }
    }

    @Override
    protected PropertyInfo replaceProperty(PropertyInfo original) {
        FieldInfo field;
        String name = original.getName();
        if (!original.isReadable()) {
            FieldInfo field2 = this.getField(name);
            if (field2 != null && original.getType().isAssignableFrom(field2.getType())) {
                return new SetterAndFieldPropertyInfo(original, field2);
            }
        } else if (!original.isWritable() && (field = this.getField(name)) != null && original.getType().isAssignableFrom(field.getType())) {
            return new GetterAndFieldPropertyInfo(original, field);
        }
        return original;
    }

    protected void setFields(Set<FieldInfo> fields) {
        if (fields != null && !fields.isEmpty()) {
            this.fieldsByName = new HashMap<String, FieldInfo>(fields.size());
            for (FieldInfo field : fields) {
                this.fieldsByName.put(field.getName(), field);
            }
        } else {
            this.fieldsByName = Collections.emptyMap();
        }
    }

    protected FieldInfo getField(String name) {
        return this.fieldsByName.get(name);
    }

    protected static Set<FieldInfo> getFields(ClassInfo classInfo, FieldFilter filter) {
        HashSet<FieldInfo> fields = new HashSet<FieldInfo>();
        while (classInfo != null) {
            FieldInfo[] finfos = classInfo.getDeclaredFields();
            if (finfos != null && finfos.length > 0) {
                for (FieldInfo field : finfos) {
                    if (!filter.useField(field)) continue;
                    fields.add(field);
                }
            }
            classInfo = classInfo.getSuperclass();
        }
        return fields;
    }

    protected FieldFilter getFieldFilter() {
        return FieldFilter.PUBLIC;
    }
}

