/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.core;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class NodeLocation {
    private static Log log = ExoLogger.getLogger((String)"wcm:NodeLocation");
    private String repository;
    private String workspace;
    private String path;

    public NodeLocation() {
    }

    public NodeLocation(String repository, String workspace, String path) {
        this.repository = repository;
        this.workspace = workspace;
        this.path = path;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Deprecated
    public static final NodeLocation parse(String exp) {
        String[] temp = exp.split(":");
        if (temp.length == 3 && temp[2].indexOf("/") == 0) {
            return new NodeLocation(temp[0], temp[1], temp[2]);
        }
        throw new IllegalArgumentException("Invalid expression: " + exp + ". An valid expression has pattern repository:workspace:path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static final NodeLocation make(Node node) {
        Session session = null;
        try {
            session = node.getSession();
            String repository = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
            String workspace = session.getWorkspace().getName();
            String path = node.getPath();
            session.logout();
            NodeLocation nodeLocation = new NodeLocation(repository, workspace, path);
            return nodeLocation;
        }
        catch (RepositoryException e) {
            log.error((Object)"make() failed because of ", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return null;
    }

    public static final NodeLocation getNodeLocationByExpression(String exp) {
        String[] temp = exp.split(":");
        if (temp.length >= 3 && temp[2].indexOf("/") == 0) {
            String repository = temp[0];
            String workspace = temp[1];
            String nodepath = exp.substring(repository.length() + workspace.length() + 2);
            return new NodeLocation(repository, workspace, nodepath);
        }
        throw new IllegalArgumentException("Invalid expression: " + exp + ". An valid expression has pattern repository:workspace:path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final NodeLocation getNodeLocationByNode(Node node) {
        Session session = null;
        try {
            session = node.getSession();
            String repository = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
            String workspace = session.getWorkspace().getName();
            String path = node.getPath();
            session.logout();
            NodeLocation nodeLocation = new NodeLocation(repository, workspace, path);
            return nodeLocation;
        }
        catch (RepositoryException e) {
            log.error((Object)"getNodeLocationByNode() failed because of ", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Node getNodeByLocation(NodeLocation nodeLocation) {
        Session session = null;
        try {
            ManageableRepository repository = WCMCoreUtils.getRepository(nodeLocation.getRepository());
            session = WCMCoreUtils.getSystemSessionProvider().getSession(nodeLocation.getWorkspace(), repository);
            Node node = (Node)session.getItem(nodeLocation.getPath());
            session.logout();
            Node node2 = node;
            return node2;
        }
        catch (Exception e) {
            log.error((Object)"getNodeByNodeLocation() failed because of ", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return null;
    }

    public static final Node getNodeByExpression(String expression) {
        return NodeLocation.getNodeByLocation(NodeLocation.parse(expression));
    }

    public static final String getExpressionByNode(Node node) {
        NodeLocation location = NodeLocation.getNodeLocationByNode(node);
        return NodeLocation.mergeString(location.getRepository(), location.getWorkspace(), location.getPath());
    }

    public static final String getExpressionByNodeLocation(NodeLocation location) {
        return NodeLocation.mergeString(location.getRepository(), location.getWorkspace(), location.getPath());
    }

    public String toString() {
        return NodeLocation.mergeString(this.repository, this.workspace, this.path);
    }

    private static String mergeString(String repository, String workspace, String path) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(repository);
        buffer.append(":");
        buffer.append(workspace);
        buffer.append(":");
        buffer.append(path);
        return buffer.toString();
    }
}

