/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableInput;

public class RandomAccessFileInputStream
extends InputStream
implements SeekableInput {
    private static final Logger logger = Logger.getLogger(RandomAccessFileInputStream.class.toString());
    private long m_lMarkPosition = 0L;
    private RandomAccessFile m_RandomAccessFile;
    private final Object m_oLock;
    private Object m_oCurrentUser;

    public static RandomAccessFileInputStream build(File file) throws FileNotFoundException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        RandomAccessFileInputStream randomAccessFileInputStream = new RandomAccessFileInputStream(randomAccessFile);
        return randomAccessFileInputStream;
    }

    protected RandomAccessFileInputStream(RandomAccessFile randomAccessFile) {
        this.m_RandomAccessFile = randomAccessFile;
        this.m_oLock = new Object();
    }

    public int read() throws IOException {
        return this.m_RandomAccessFile.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.m_RandomAccessFile.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.m_RandomAccessFile.read(byArray, n, n2);
    }

    public void close() throws IOException {
        this.m_RandomAccessFile.close();
    }

    public int available() {
        return 0;
    }

    public void mark(int n) {
        try {
            this.m_lMarkPosition = this.m_RandomAccessFile.getFilePointer();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public boolean markSupported() {
        return true;
    }

    public void reset() throws IOException {
        this.m_RandomAccessFile.seek(this.m_lMarkPosition);
    }

    public long skip(long l) throws IOException {
        int n = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        return this.m_RandomAccessFile.skipBytes(n);
    }

    public void seekAbsolute(long l) throws IOException {
        this.m_RandomAccessFile.seek(l);
    }

    public void seekRelative(long l) throws IOException {
        long l2 = this.m_RandomAccessFile.getFilePointer();
        if ((l2 += l) < 0L) {
            l2 = 0L;
        }
        this.m_RandomAccessFile.seek(l2);
    }

    public void seekEnd() throws IOException {
        long l = this.m_RandomAccessFile.length();
        this.seekAbsolute(l);
    }

    public long getAbsolutePosition() throws IOException {
        return this.m_RandomAccessFile.getFilePointer();
    }

    public long getLength() throws IOException {
        return this.m_RandomAccessFile.length();
    }

    public InputStream getInputStream() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginThreadAccess() {
        Object object = this.m_oLock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            while (true) {
                if (this.m_oCurrentUser == null) {
                    this.m_oCurrentUser = thread;
                    break;
                }
                if (this.m_oCurrentUser == thread) break;
                try {
                    this.m_oLock.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endThreadAccess() {
        Object object = this.m_oLock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            if (this.m_oCurrentUser == null) {
                this.m_oLock.notifyAll();
            } else if (this.m_oCurrentUser == thread) {
                this.m_oCurrentUser = null;
                this.m_oLock.notifyAll();
            } else if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("ERROR:  Thread finished using SeekableInput, but it wasn't locked by that Thread\n        Thread: " + Thread.currentThread() + "\n" + "        Locking Thread: " + this.m_oCurrentUser + "\n" + "        SeekableInput: " + this);
            }
        }
    }
}

