/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.PTrailer;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Parser;
import org.icepdf.core.util.Utils;

public class CrossReference {
    private static final Logger logger = Logger.getLogger(CrossReference.class.toString());
    private Hashtable<Number, Entry> m_hObjectNumber2Entry = new Hashtable(4096);
    private PTrailer m_PTrailer;
    private CrossReference m_xrefPrevious;
    private CrossReference m_xrefPeer;
    private boolean m_bIsCrossReferenceTable;
    private boolean m_bHaveTriedLoadingPrevious;
    private boolean m_bHaveTriedLoadingPeer;

    public void setTrailer(PTrailer pTrailer) {
        this.m_PTrailer = pTrailer;
    }

    public void addXRefTableEntries(Parser parser) {
        this.m_bIsCrossReferenceTable = true;
        try {
            block2: while (true) {
                Object object;
                if (!((object = parser.getNumberOrStringWithMark(16)) instanceof Number)) {
                    parser.ungetNumberOrStringWithReset();
                    break;
                }
                int n = ((Number)object).intValue();
                int n2 = ((Number)parser.getToken()).intValue();
                int n3 = n;
                int n4 = 0;
                while (true) {
                    if (n4 >= n2) continue block2;
                    long l = parser.getIntSurroundedByWhitespace();
                    int n5 = parser.getIntSurroundedByWhitespace();
                    char c = parser.getCharSurroundedByWhitespace();
                    if (c == 'n') {
                        this.addUsedEntry(n3, l, n5);
                    } else if (c == 'f') {
                        this.addFreeEntry(n3, (int)l, n5);
                    }
                    ++n3;
                    ++n4;
                }
                break;
            }
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Error parsing xRef table entries.", iOException);
        }
    }

    public void addXRefStreamEntries(Library library, Hashtable hashtable, InputStream inputStream) {
        try {
            int n;
            int n2 = library.getInt(hashtable, "Size");
            Vector<Integer> vector = (Vector<Integer>)library.getObject(hashtable, "Index");
            if (vector == null) {
                vector = new Vector<Integer>(2);
                vector.add(0);
                vector.add(n2);
            }
            Vector vector2 = (Vector)library.getObject(hashtable, "W");
            int[] nArray = null;
            if (vector2 != null) {
                nArray = new int[vector2.size()];
                for (n = 0; n < vector2.size(); ++n) {
                    nArray[n] = ((Number)vector2.get(n)).intValue();
                }
            }
            n = nArray[0];
            int n3 = nArray[1];
            int n4 = nArray[2];
            for (int i = 0; i < vector.size(); i += 2) {
                int n5 = ((Number)vector.get(i)).intValue();
                int n6 = ((Number)vector.get(i + 1)).intValue();
                int n7 = n5 + n6;
                for (int j = n5; j < n7; ++j) {
                    int n8;
                    int n9;
                    int n10 = 1;
                    if (n > 0) {
                        n10 = Utils.readIntWithVaryingBytesBE(inputStream, n);
                    }
                    if (n10 == 0) {
                        n9 = Utils.readIntWithVaryingBytesBE(inputStream, n3);
                        n8 = Utils.readIntWithVaryingBytesBE(inputStream, n4);
                        this.addFreeEntry(j, n9, n8);
                        continue;
                    }
                    if (n10 == 1) {
                        long l = Utils.readLongWithVaryingBytesBE(inputStream, n3);
                        int n11 = 0;
                        if (n4 > 0) {
                            n11 = Utils.readIntWithVaryingBytesBE(inputStream, n4);
                        }
                        this.addUsedEntry(j, l, n11);
                        continue;
                    }
                    if (n10 != 2) continue;
                    n9 = Utils.readIntWithVaryingBytesBE(inputStream, n3);
                    n8 = Utils.readIntWithVaryingBytesBE(inputStream, n4);
                    this.addCompressedEntry(j, n9, n8);
                }
            }
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Error parsing xRef stream entries.", iOException);
        }
    }

    public Entry getEntryForObject(Integer n) {
        Entry entry = this.m_hObjectNumber2Entry.get(n);
        if (entry != null) {
            return entry;
        }
        if (this.m_bIsCrossReferenceTable && !this.m_bHaveTriedLoadingPeer && this.m_xrefPeer == null && this.m_PTrailer != null) {
            this.m_PTrailer.loadXRefStmIfApplicable();
            this.m_xrefPeer = this.m_PTrailer.getCrossReferenceStream();
            this.m_bHaveTriedLoadingPeer = true;
        }
        if (this.m_xrefPeer != null && (entry = this.m_xrefPeer.getEntryForObject(n)) != null) {
            return entry;
        }
        if (!this.m_bHaveTriedLoadingPrevious && this.m_xrefPrevious == null && this.m_PTrailer != null) {
            this.m_PTrailer.onDemandLoadAndSetupPreviousTrailer();
            this.m_bHaveTriedLoadingPrevious = true;
        }
        if (this.m_xrefPrevious != null && (entry = this.m_xrefPrevious.getEntryForObject(n)) != null) {
            return entry;
        }
        return entry;
    }

    public void addToEndOfChainOfPreviousXRefs(CrossReference crossReference) {
        if (this.m_xrefPrevious == null) {
            this.m_xrefPrevious = crossReference;
        } else {
            this.m_xrefPrevious.addToEndOfChainOfPreviousXRefs(crossReference);
        }
    }

    protected void addFreeEntry(int n, int n2, int n3) {
        FreeEntry freeEntry = new FreeEntry(n, n2, n3);
    }

    protected void addUsedEntry(int n, long l, int n2) {
        UsedEntry usedEntry = new UsedEntry(n, l, n2);
        this.m_hObjectNumber2Entry.put(n, usedEntry);
    }

    protected void addCompressedEntry(int n, int n2, int n3) {
        CompressedEntry compressedEntry = new CompressedEntry(n, n2, n3);
        this.m_hObjectNumber2Entry.put(n, compressedEntry);
    }

    public static class CompressedEntry
    extends Entry {
        private int m_iObjectNumberOfContainingObjectStream;
        private int m_iIndexWithinObjectStream;

        CompressedEntry(int n, int n2, int n3) {
            super(2, n);
            this.m_iObjectNumberOfContainingObjectStream = n2;
            this.m_iIndexWithinObjectStream = n3;
        }

        public int getObjectNumberOfContainingObjectStream() {
            return this.m_iObjectNumberOfContainingObjectStream;
        }

        public int getIndexWithinObjectStream() {
            return this.m_iIndexWithinObjectStream;
        }
    }

    public static class UsedEntry
    extends Entry {
        private long m_lFilePositionOfObject;
        private int m_iGenerationNumber;

        UsedEntry(int n, long l, int n2) {
            super(1, n);
            this.m_lFilePositionOfObject = l;
            this.m_iGenerationNumber = n2;
        }

        public long getFilePositionOfObject() {
            return this.m_lFilePositionOfObject;
        }

        public int getGenerationNumber() {
            return this.m_iGenerationNumber;
        }
    }

    public static class FreeEntry
    extends Entry {
        private int m_iNextFreeObjectNumber;
        private int m_iGenerationNumberIfReused;

        FreeEntry(int n, int n2, int n3) {
            super(0, n);
            this.m_iNextFreeObjectNumber = n2;
            this.m_iGenerationNumberIfReused = n3;
        }

        public int getNextFreeObjectNumber() {
            return this.m_iNextFreeObjectNumber;
        }

        public int getGenerationNumberIfReused() {
            return this.m_iGenerationNumberIfReused;
        }
    }

    public static class Entry {
        public static final int TYPE_FREE = 0;
        public static final int TYPE_USED = 1;
        public static final int TYPE_COMPRESSED = 2;
        private int m_iType;
        private int m_iObjectNumber;

        Entry(int n, int n2) {
            this.m_iType = n;
            this.m_iObjectNumber = n2;
        }

        int getType() {
            return this.m_iType;
        }

        int getObjectNumber() {
            return this.m_iObjectNumber;
        }
    }
}

