/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.graphics.ExtGState;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.pobjects.graphics.Pattern;
import org.icepdf.core.pobjects.graphics.ShadingType2Pattern;
import org.icepdf.core.pobjects.graphics.ShadingType3Pattern;
import org.icepdf.core.util.Library;

public abstract class ShadingPattern
extends Dictionary
implements Pattern {
    private static final Logger logger = Logger.getLogger(ShadingPattern.class.toString());
    public static final int SHADING_PATTERN_TYPE_1 = 1;
    public static final int SHADING_PATTERN_TYPE_2 = 2;
    public static final int SHADING_PATTERN_TYPE_3 = 3;
    public static final int SHADING_PATTERN_TYPE_4 = 4;
    public static final int SHADING_PATTERN_TYPE_5 = 5;
    public static final int SHADING_PATTERN_TYPE_6 = 6;
    protected String type;
    protected int patternType;
    protected Hashtable shading;
    protected int shadingType;
    protected Rectangle2D bBox;
    protected PColorSpace colorSpace;
    protected Vector background;
    protected boolean antiAlias;
    protected AffineTransform matrix;
    protected ExtGState extGState;
    protected boolean inited;

    public ShadingPattern(Library library, Hashtable hashtable) {
        super(library, hashtable);
        this.type = library.getName(hashtable, "Type");
        this.patternType = library.getInt(hashtable, "PatternType");
        Object object = library.getObject(hashtable, "ExtGState");
        if (object instanceof Hashtable) {
            this.extGState = new ExtGState(library, (Hashtable)object);
        } else if (object instanceof Reference) {
            this.extGState = new ExtGState(library, (Hashtable)library.getObject((Reference)object));
        }
        Vector vector = (Vector)library.getObject(hashtable, "Matrix");
        this.matrix = vector != null ? ShadingPattern.getAffineTransform(vector) : new AffineTransform();
    }

    public static ShadingPattern getShadingPattern(Library library, Hashtable hashtable) {
        Hashtable hashtable2 = library.getDictionary(hashtable, "Shading");
        if (hashtable2 != null) {
            return ShadingPattern.shadingFactory(library, hashtable, hashtable2);
        }
        return null;
    }

    public static ShadingPattern getShadingPattern(Library library, Hashtable hashtable, Hashtable hashtable2) {
        if (hashtable != null) {
            ShadingPattern shadingPattern = ShadingPattern.shadingFactory(library, hashtable2, hashtable2);
            shadingPattern.setShading(hashtable2);
            return shadingPattern;
        }
        return null;
    }

    private static ShadingPattern shadingFactory(Library library, Hashtable hashtable, Hashtable hashtable2) {
        int n = library.getInt(hashtable2, "ShadingType");
        if (n == 2) {
            return new ShadingType2Pattern(library, hashtable);
        }
        if (n == 3) {
            return new ShadingType3Pattern(library, hashtable);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Shading pattern of Type " + n + " are not currently supported");
        }
        return null;
    }

    private static AffineTransform getAffineTransform(Vector vector) {
        float[] fArray = new float[6];
        for (int i = 0; i < 6; ++i) {
            fArray[i] = ((Number)vector.elementAt(i)).floatValue();
        }
        return new AffineTransform(fArray);
    }

    public abstract Paint getPaint();

    public abstract void init();

    public void setParentGraphicState(GraphicsState graphicsState) {
    }

    public void setMatrix(AffineTransform affineTransform) {
        this.matrix = affineTransform;
    }

    public int getPatternType() {
        return this.patternType;
    }

    public Rectangle2D getBBox() {
        return this.bBox;
    }

    public AffineTransform getMatrix() {
        return this.matrix;
    }

    public int getShadingType() {
        return this.shadingType;
    }

    public void setShading(Hashtable hashtable) {
        this.shading = hashtable;
    }

    public String getType() {
        return this.type;
    }

    public PColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public Vector getBackground() {
        return this.background;
    }

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    public ExtGState getExtGState() {
        return this.extGState;
    }

    public boolean isInited() {
        return this.inited;
    }

    public String toString() {
        return "Shading Pattern: \n           type: pattern \n    patternType: shading\n         matrix: " + this.matrix + "\n      extGState: " + this.extGState + "\n        shading dictionary: " + this.shading + "\n               shadingType: " + this.shadingType + "\n               colourSpace: " + this.colorSpace + "\n                background: " + this.background + "\n                      bbox: " + this.bBox + "\n                 antiAlias: " + this.antiAlias;
    }
}

