/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.plugins.values.mappers;

import java.io.Serializable;
import java.lang.reflect.Type;
import javax.management.ObjectName;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.CompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.PropertiesMetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.plugins.types.ObjectNameTypeBuilder;
import org.jboss.metatype.spi.values.MetaMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesCompositeObjectNameMetaMapper
extends MetaMapper<ObjectName> {
    @Override
    public MetaType getMetaType() {
        return ObjectNameTypeBuilder.META_TYPE;
    }

    @Override
    public Type mapToType() {
        return ObjectName.class;
    }

    @Override
    public MetaValue createMetaValue(MetaType metaType, ObjectName object) {
        String[] itemNames = new String[]{"domain", "keyPropertyList"};
        PropertiesMetaValue keyValues = new PropertiesMetaValue();
        for (String key : object.getKeyPropertyList().keySet()) {
            String value = object.getKeyProperty(key);
            keyValues.put(key, value);
        }
        MetaValue[] itemValues = new MetaValue[]{SimpleValueSupport.wrap((Serializable)((Object)object.getDomain())), keyValues};
        CompositeValueSupport mv = new CompositeValueSupport(ObjectNameTypeBuilder.META_TYPE, itemNames, itemValues);
        return mv;
    }

    @Override
    public ObjectName unwrapMetaValue(MetaValue metaValue) {
        CompositeValue compositeValue = (CompositeValue)metaValue;
        SimpleValue domain = (SimpleValue)compositeValue.get("domain");
        String domainUnwrap = domain.toString();
        MetaValue keys = compositeValue.get("keyPropertyList");
        PropertiesMetaValue keysUnwrap = null;
        if (keys instanceof PropertiesMetaValue) {
            keysUnwrap = (PropertiesMetaValue)keys;
        }
        try {
            ObjectName name = new ObjectName(domainUnwrap, keysUnwrap);
            return name;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

