/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.invocation.OnewayInvocation;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.ws.core.soap.SOAPMessageImpl;

public class SOAPMessageMarshaller
implements Marshaller {
    private static Logger log = Logger.getLogger(SOAPMessageMarshaller.class);

    public void write(Object dataObject, OutputStream output) throws IOException {
        if (dataObject instanceof InvocationRequest) {
            dataObject = ((InvocationRequest)dataObject).getParameter();
        }
        if (dataObject instanceof OnewayInvocation) {
            dataObject = ((OnewayInvocation)dataObject).getParameters()[0];
        }
        if (!(dataObject instanceof SOAPMessage)) {
            throw new IllegalArgumentException("Not a SOAPMessage: " + dataObject);
        }
        SOAPMessageImpl soapMessage = (SOAPMessageImpl)dataObject;
        soapMessage.writeTo(output);
    }

    public Marshaller cloneMarshaller() throws CloneNotSupportedException {
        return new SOAPMessageMarshaller();
    }
}

