/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.orbportability;

import com.arjuna.orbportability.common.opPropertyManager;
import com.arjuna.orbportability.internal.common.LocalSetup;
import com.arjuna.orbportability.internal.utils.PostInitLoader;
import com.arjuna.orbportability.internal.utils.PostSetLoader;
import com.arjuna.orbportability.internal.utils.PreInitLoader;
import com.arjuna.orbportability.logging.opLogger;
import com.arjuna.orbportability.orb.Attribute;
import com.arjuna.orbportability.orb.PostShutdown;
import com.arjuna.orbportability.orb.PreShutdown;
import com.arjuna.orbportability.orb.Shutdown;
import java.applet.Applet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import org.omg.CORBA.SystemException;

public class ORB {
    com.arjuna.orbportability.orb.core.ORB _orb = new com.arjuna.orbportability.orb.core.ORB();
    private Hashtable _preORBShutdown = new Hashtable();
    private Hashtable _postORBShutdown = new Hashtable();
    private Hashtable _preORBInitProperty = new Hashtable();
    private Hashtable _postORBInitProperty = new Hashtable();
    private String _orbName = null;
    private static HashMap _orbMap = new HashMap();
    static final String ORB_INITIALISER_NS = "com.arjuna.orbportability.orb";

    public synchronized void initORB() throws SystemException {
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "ORB::initORB ()");
        }
        if (!this._orb.initialised()) {
            this.loadProperties(null);
            PreInitLoader preInit = new PreInitLoader(PreInitLoader.generateORBPropertyName(ORB_INITIALISER_NS), this);
            preInit = new PreInitLoader(PreInitLoader.generateORBPropertyName(ORB_INITIALISER_NS, this._orbName), this);
            preInit = null;
            this.parseProperties(null, false);
            this._orb.init();
            this.parseProperties(null, true);
            PostInitLoader postInit = new PostInitLoader(PostInitLoader.generateORBPropertyName(ORB_INITIALISER_NS), this);
            postInit = new PostInitLoader(PostInitLoader.generateORBPropertyName(ORB_INITIALISER_NS, this._orbName), this);
            Object var2_2 = null;
        }
    }

    public synchronized void initORB(Applet a, Properties p) throws SystemException {
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "ORB::initORB (Applet, Properties)");
        }
        if (!this._orb.initialised()) {
            this.loadProperties(p);
            PreInitLoader preInit = new PreInitLoader(PreInitLoader.generateORBPropertyName(ORB_INITIALISER_NS), this);
            preInit = new PreInitLoader(PreInitLoader.generateORBPropertyName(ORB_INITIALISER_NS, this._orbName), this);
            preInit = null;
            this.parseProperties(null, false);
            this._orb.init(a, p);
            this.parseProperties(null, true);
            PostInitLoader postInit = new PostInitLoader(PostInitLoader.generateORBPropertyName(ORB_INITIALISER_NS), this);
            postInit = new PostInitLoader(PostInitLoader.generateORBPropertyName(ORB_INITIALISER_NS, this._orbName), this);
            postInit = null;
        }
    }

    public synchronized void initORB(String[] s, Properties p) throws SystemException {
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "ORB::initORB (String[], Properties)");
        }
        if (!this._orb.initialised()) {
            this.loadProperties(p);
            PreInitLoader preInit = new PreInitLoader(PreInitLoader.generateORBPropertyName(ORB_INITIALISER_NS), this);
            preInit = new PreInitLoader(PreInitLoader.generateORBPropertyName(ORB_INITIALISER_NS, this._orbName), this);
            preInit = null;
            this.parseProperties(s, false);
            this._orb.init(s, p);
            this.parseProperties(s, true);
            PostInitLoader postInit = new PostInitLoader(PostInitLoader.generateORBPropertyName(ORB_INITIALISER_NS), this);
            postInit = new PostInitLoader(PostInitLoader.generateORBPropertyName(ORB_INITIALISER_NS, this._orbName), this);
            postInit = null;
        }
    }

    public synchronized boolean addAttribute(Attribute p) {
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "ORB::addAttribute (" + p + ")");
        }
        if (this._orb.initialised()) {
            return false;
        }
        if (p.postORBInit()) {
            this._postORBInitProperty.put(p, p);
        } else {
            this._preORBInitProperty.put(p, p);
        }
        return true;
    }

    public synchronized void shutdown() {
        Shutdown c;
        Enumeration elements;
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "ORB::shutdown ()");
        }
        if (!this._preORBShutdown.isEmpty()) {
            elements = this._preORBShutdown.elements();
            while (elements.hasMoreElements()) {
                c = (PreShutdown)elements.nextElement();
                if (c == null) continue;
                if (opLogger.logger.isDebugEnabled()) {
                    opLogger.logger.debug(16L, 4L, 1L, "ORB - pre-orb shutdown on " + c.name());
                }
                ((PreShutdown)c).work();
                c = null;
            }
        }
        if (this._orb.initialised()) {
            this._orb.shutdown();
        }
        if (!this._postORBShutdown.isEmpty()) {
            elements = this._postORBShutdown.elements();
            while (elements.hasMoreElements()) {
                c = (PostShutdown)elements.nextElement();
                if (c == null) continue;
                if (opLogger.logger.isDebugEnabled()) {
                    opLogger.logger.debug(16L, 4L, 1L, "ORB - post-orb shutdown on " + c.name());
                }
                ((PostShutdown)c).work();
                Object var2_2 = null;
            }
        }
    }

    public synchronized org.omg.CORBA.ORB orb() {
        return this._orb.orb();
    }

    public synchronized boolean setOrb(org.omg.CORBA.ORB theORB) {
        if (!this._orb.initialised()) {
            this._orb.orb(theORB);
            new PostSetLoader(PostSetLoader.generateORBPropertyName(ORB_INITIALISER_NS), this);
            new PostSetLoader(PostSetLoader.generateORBPropertyName(ORB_INITIALISER_NS, this._orbName), this);
            return true;
        }
        return false;
    }

    public synchronized void addPreShutdown(PreShutdown c) {
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "ORB::addPreShutdown (" + c + ")");
        }
        this._preORBShutdown.put(c, c);
    }

    public synchronized void addPostShutdown(PostShutdown c) {
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "ORB::addPostShutdown (" + c + ")");
        }
        this._postORBShutdown.put(c, c);
    }

    public synchronized void destroy() throws SystemException {
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "ORB::destroyORB ()");
        }
        this._orb.destroy();
    }

    protected ORB(String orbName) {
        this._orbName = orbName;
        this.addAttribute(new LocalSetup());
    }

    private void loadProperties(Properties p) {
        if (p != null && !p.isEmpty()) {
            Enumeration<Object> properties = p.keys();
            while (properties.hasMoreElements()) {
                String o = (String)properties.nextElement();
                if (!PreInitLoader.isPreInitProperty(o) && !PostInitLoader.isPostInitProperty(o)) continue;
                if (opLogger.logger.isDebugEnabled()) {
                    opLogger.logger.debug(16L, 4L, 1L, "Adding property '" + o + "' to the ORB portability properties");
                }
                opPropertyManager.propertyManager.setProperty(o, p.getProperty(o));
            }
        }
    }

    private void parseProperties(String[] params, boolean postInit) {
        Hashtable work;
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "ORB::parseProperties (String[], " + postInit + ")");
        }
        Hashtable hashtable = work = postInit ? this._postORBInitProperty : this._preORBInitProperty;
        if (!work.isEmpty()) {
            Enumeration elements = work.elements();
            while (elements.hasMoreElements()) {
                Attribute p = (Attribute)elements.nextElement();
                if (p == null) continue;
                if (opLogger.logger.isDebugEnabled()) {
                    opLogger.logger.debug(16L, 4L, 1L, "Attribute " + p + " initialising.");
                }
                p.initialise(params);
                p = null;
            }
        }
    }

    public static synchronized ORB getInstance(String uniqueId) {
        ORB orb = (ORB)_orbMap.get(uniqueId);
        if (orb == null) {
            orb = new ORB(uniqueId);
            _orbMap.put(uniqueId, orb);
        }
        return orb;
    }

    String getName() {
        return this._orbName;
    }
}

