/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav;

import java.util.Hashtable;

public final class WebDavConst {
    public static final String WDBDAV_COMMAND_CATALOG = "WEBDAV";
    public static final String HTTPVER = "HTTP/1.1";
    public static final String BOUNDARY = "1234567890";
    public static final String DAV_MSAUTHORVIA = "DAV";
    public static final String DAV_NAMESPACE = "DAV:";
    public static final String EXO_NAMESPACE = "http://exoplatform.com/jcr";
    public static final String DAV_PREFIX = "D:";
    public static final String DAV_SERVER = "eXo-Webdav Server /1.0";
    public static final String DAV_HEADER = "1, 2, ordered-collections";
    public static final String DASL_VALUE = "<DAV:basicsearch><exo:sql xmlns:exo=\"http://exoplatform.com/jcr\"/><exo:xpath xmlns:exo=\"http://exoplatform.com/jcr\"/>";
    public static final String DAV_VERSIONIDENTIFIER = "VERSIONID";
    public static final String DAV_VERSIONPREFIX = "?VERSIONID=";
    public static final String DAV_DEFAULT_MIME_TYPE = "text/plain";
    private static Hashtable<Integer, String> statusDescriptions = new Hashtable();

    private WebDavConst() {
    }

    private static void registerDescr(int status, String descr) {
        statusDescriptions.put(new Integer(status), descr);
    }

    public static String getStatusDescription(int status) {
        String description = "";
        Integer statusKey = new Integer(status);
        if (statusDescriptions.containsKey(statusKey)) {
            description = statusDescriptions.get(statusKey);
        }
        return String.format("%s %d %s", HTTPVER, status, description);
    }

    static {
        WebDavConst.registerDescr(100, "Continue");
        WebDavConst.registerDescr(101, "Switching Protocols");
        WebDavConst.registerDescr(200, "OK");
        WebDavConst.registerDescr(201, "Created");
        WebDavConst.registerDescr(202, "Accepted");
        WebDavConst.registerDescr(203, "Non-Authoritative Information");
        WebDavConst.registerDescr(204, "No Content");
        WebDavConst.registerDescr(205, "Reset Content");
        WebDavConst.registerDescr(206, "Partial Content");
        WebDavConst.registerDescr(207, "Multi Status");
        WebDavConst.registerDescr(300, "Multiple Choices");
        WebDavConst.registerDescr(301, "Moved Permanently");
        WebDavConst.registerDescr(302, "Found");
        WebDavConst.registerDescr(303, "See Other");
        WebDavConst.registerDescr(304, "Not Modified");
        WebDavConst.registerDescr(305, "Use Proxy");
        WebDavConst.registerDescr(307, "Temporary Redirect");
        WebDavConst.registerDescr(400, "Bad Request");
        WebDavConst.registerDescr(401, "Unauthorized");
        WebDavConst.registerDescr(402, "Payment Required");
        WebDavConst.registerDescr(403, "Forbidden");
        WebDavConst.registerDescr(404, "Not Found");
        WebDavConst.registerDescr(405, "Method Not Allowed");
        WebDavConst.registerDescr(406, "Not Acceptable");
        WebDavConst.registerDescr(407, "Proxy Authentication Required");
        WebDavConst.registerDescr(408, "Request Timeout");
        WebDavConst.registerDescr(409, "Conflict");
        WebDavConst.registerDescr(410, "Gone");
        WebDavConst.registerDescr(411, "Length Required");
        WebDavConst.registerDescr(412, "Precondition Failed");
        WebDavConst.registerDescr(414, "Request Entity Too Large");
        WebDavConst.registerDescr(414, "Request-URI Too Long");
        WebDavConst.registerDescr(415, "Unsupported Media Type");
        WebDavConst.registerDescr(416, "Requested Range Not Satisfiable");
        WebDavConst.registerDescr(417, "Expectation Failed");
        WebDavConst.registerDescr(500, "Internal Server Error");
        WebDavConst.registerDescr(501, "Not Implemented");
        WebDavConst.registerDescr(502, "Bad Gateway");
        WebDavConst.registerDescr(503, "Service Unavailable");
        WebDavConst.registerDescr(504, "Gateway Timeout");
        WebDavConst.registerDescr(505, "HTTP Version Not Supported");
    }

    public final class DateFormat {
        public static final String CREATION = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        public static final String MODIFICATION = "EEE, dd MMM yyyy HH:mm:ss z";

        private DateFormat() {
        }
    }

    public final class NodeTypes {
        public static final String JCR_CONTENT = "jcr:content";
        public static final String JCR_NODE_TYPE = "jcr:nodeType";
        public static final String JCR_DATA = "jcr:data";
        public static final String JCR_FROZENNODE = "jcr:frozenNode";
        public static final String JCR_LOCKOWNER = "jcr:lockOwner";
        public static final String NT_VERSION = "nt:version";
        public static final String JCR_CREATED = "jcr:created";
        public static final String NT_FILE = "nt:file";
        public static final String JCR_ROOTVERSION = "jcr:rootVersion";
        public static final String JCR_LASTMODIFIED = "jcr:lastModified";
        public static final String JCR_MIMETYPE = "jcr:mimeType";
        public static final String NT_RESOURCE = "nt:resource";
        public static final String MIX_LOCKABLE = "mix:lockable";
        public static final String MIX_VERSIONABLE = "mix:versionable";
        public static final String NT_FOLDER = "nt:folder";

        private NodeTypes() {
        }
    }

    public final class Lock {
        public static final String SCOPE_SHARED = "shared";
        public static final String SCOPE_EXCLUSIVE = "exclusive";
        public static final String TYPE_WRITE = "write";
        public static final String OPAQUE_LOCK_TOKEN = "opaquelocktoken";

        private Lock() {
        }
    }

    public final class CacheConstants {
        public static final String NO_CACHE = "no-cache";

        private CacheConstants() {
        }
    }

    public final class ResourceType {
        public static final String COLLECTION = "collection";
        public static final String RESOURCE = "resource";

        private ResourceType() {
        }
    }

    public final class DavProperty {
        public static final String DEPTH = "depth";
        public static final String MULTISTATUS = "multistatus";
        public static final String PROPFIND = "propfind";
        public static final String SUPPORDEDMETHODSET = "supported-method-set";

        private DavProperty() {
        }
    }

    public final class DavDocument {
        public static final String ACLPRINCIPALPROPS = "acl-principal-props";
        public static final String ACLPRINCIPALPROPSET = "acl-principal-prop-set";
        public static final String EXPANDPROPERTY = "";
        public static final String LOCKINFO = "lockinfo";
        public static final String PROPERTYBEHAVIOR = "";
        public static final String PROPERTYUPDATE = "propertyupdate";
        public static final String PROPFIND = "propfind";
        public static final String VERSIONTREE = "version-tree";
        public static final String ORDERPATCH = "orderpatch";
        public static final String SEARCHREQUEST = "searchrequest";

        private DavDocument() {
        }
    }
}

