/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.util;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTypeUtil {
    public static String getFileNodeType(String fileNodeTypeHeader) throws NoSuchNodeTypeException {
        if (fileNodeTypeHeader != null && !fileNodeTypeHeader.equals("nt:file")) {
            throw new NoSuchNodeTypeException("Unsupported file node type: " + fileNodeTypeHeader);
        }
        return null;
    }

    public static String getContentNodeType(String contentNodeTypeHeader) {
        if (contentNodeTypeHeader != null) {
            return contentNodeTypeHeader;
        }
        return "nt:resource";
    }

    public static void checkContentResourceType(NodeType contentNodeType) throws NoSuchNodeTypeException {
        if (!contentNodeType.isNodeType("nt:resource")) {
            throw new NoSuchNodeTypeException("Content-Node type " + contentNodeType.getName() + " must extend nt:resource.");
        }
    }

    public static ArrayList<String> getMixinTypes(List<String> mixinTypes) {
        ArrayList<String> mixins = new ArrayList<String>();
        if (mixinTypes == null) {
            return mixins;
        }
        return mixins;
    }
}

