/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.gatein.common.net.URLTools;
import org.gatein.common.net.media.MediaType;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.ResourceURL;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.cache.CacheLevel;
import org.gatein.wsrp.WSRPPortletURL;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSRPResourceURL
extends WSRPPortletURL
implements ResourceURL {
    private static final Logger log = Logger.getLogger(WSRPResourceURL.class);
    private String resourceId;
    private StateString resourceState;
    private CacheLevel cacheability;
    private boolean requiresRewrite = false;
    private URL resourceURL;
    private static final Map<String, MediaType> SUPPORTED_RESOURCE_TYPES = new HashMap<String, MediaType>(11);

    public WSRPResourceURL() {
    }

    public WSRPResourceURL(Mode mode, WindowState windowState, boolean secure, StateString navigationalState, StateString resourceState, String resourceId, CacheLevel cacheability) {
        super(mode, windowState, secure, navigationalState);
        this.resourceId = resourceId;
        this.resourceState = resourceState;
        this.cacheability = cacheability;
    }

    @Override
    protected String getURLType() {
        return "resource";
    }

    @Override
    protected void appendEnd(StringBuffer sb) {
        if (this.resourceURL != null) {
            this.createURLParameter(sb, "wsrp-url", URLTools.encodeXWWWFormURL((String)this.resourceURL.toExternalForm()));
        }
        this.createURLParameter(sb, "wsrp-requiresRewrite", this.requiresRewrite ? "true" : "false");
    }

    @Override
    protected void dealWithSpecificParams(Map<String, String> params, String originalURL) {
        super.dealWithSpecificParams(params, originalURL);
        String paramValue = this.getRawParameterValueFor(params, "wsrp-requiresRewrite");
        if (paramValue == null) {
            throw new IllegalArgumentException("The parsed parameters don't contain a value for the required wsrp-requiresRewrite parameter in " + originalURL);
        }
        this.requiresRewrite = Boolean.valueOf(paramValue);
        params.remove("wsrp-requiresRewrite");
        paramValue = this.getRawParameterValueFor(params, "wsrp-url");
        if (paramValue != null) {
            try {
                this.resourceId = paramValue;
                paramValue = URLTools.decodeXWWWFormURL((String)paramValue);
                this.resourceURL = new URL(paramValue);
                String extension = URLTools.getFileExtensionOrNullFrom((URL)this.resourceURL);
                MediaType mediaType = SUPPORTED_RESOURCE_TYPES.get(extension);
                if (mediaType == null) {
                    log.debug((Object)("Couldn't determine (based on extension) MIME type of file: " + this.resourceURL.getPath() + "\nRetrieving the associated resource will probably fail."));
                }
                params.remove("wsrp-url");
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Malformed URL: " + paramValue, e);
            }
        } else {
            throw new IllegalArgumentException("The parsed parameters don't contain a value for the required wsrp-url parameter in " + originalURL);
        }
    }

    public URL getResourceURL() {
        return this.resourceURL;
    }

    public void setResourceURL(URL resourceURL) {
        this.resourceURL = resourceURL;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public StateString getResourceState() {
        return this.resourceState;
    }

    public CacheLevel getCacheability() {
        return this.cacheability;
    }

    public void buildURLWith(HttpServletRequest request, PortletContext portletContext) {
        String url = WSRPResourceURL.createAbsoluteURLFrom(this.resourceId, URLTools.getServerAddressFrom((HttpServletRequest)request), portletContext.getApplicationName());
        try {
            this.resourceURL = new URL(url);
            String extension = URLTools.getFileExtensionOrNullFrom((URL)this.resourceURL);
            MediaType type = SUPPORTED_RESOURCE_TYPES.get(extension);
            if (MediaType.TEXT_CSS.equals((Object)type) || MediaType.TEXT_JAVASCRIPT.equals((Object)type) || MediaType.TEXT_HTML.equals((Object)type)) {
                this.requiresRewrite = true;
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL: " + url, e);
        }
        log.info((Object)("Attempted to build resource URL that could be accessed directly from consumer: " + this.resourceURL));
    }

    public static String createAbsoluteURLFrom(String initial, String serverAddress, String portletApplicationName) {
        String url = serverAddress;
        if (portletApplicationName != null) {
            url = url + "/" + portletApplicationName;
        }
        if (!ParameterValidation.isNullOrEmpty((String)initial)) {
            url = initial.startsWith("/") ? url + initial : url + "/" + initial;
        }
        return url;
    }

    public boolean requiresRewrite() {
        return this.requiresRewrite;
    }

    static {
        SUPPORTED_RESOURCE_TYPES.put("html", MediaType.TEXT_HTML);
        SUPPORTED_RESOURCE_TYPES.put("htm", MediaType.TEXT_HTML);
        SUPPORTED_RESOURCE_TYPES.put("css", MediaType.TEXT_CSS);
        SUPPORTED_RESOURCE_TYPES.put("js", MediaType.TEXT_JAVASCRIPT);
        SUPPORTED_RESOURCE_TYPES.put("png", MediaType.create((String)"image/png"));
        MediaType jpeg = MediaType.create((String)"image/jpeg");
        SUPPORTED_RESOURCE_TYPES.put("jpg", jpeg);
        SUPPORTED_RESOURCE_TYPES.put("jpeg", jpeg);
        SUPPORTED_RESOURCE_TYPES.put("gif", MediaType.create((String)"image/gif"));
        SUPPORTED_RESOURCE_TYPES.put("pdf", MediaType.create((String)"application/pdf"));
        SUPPORTED_RESOURCE_TYPES.put("txt", MediaType.create((String)"text/plain"));
    }
}

