/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.io.Closeable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.portal.application.PortalApplication;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;

public class PortalRequestHandler
extends WebRequestHandler {
    protected static Log log = ExoLogger.getLogger((String)"portal:PortalRequestHandler");
    private String[] PATHS = new String[]{"/public", "/private"};

    public String[] getPath() {
        return this.PATHS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(WebAppController controller, HttpServletRequest req, HttpServletResponse res) throws Exception {
        log.debug((Object)("Session ID = " + req.getSession().getId()));
        res.setHeader("Cache-Control", "no-cache");
        PortalApplication app = (PortalApplication)controller.getApplication("PortalApplication");
        PortalRequestContext context = new PortalRequestContext(app, req, res);
        if (context.getPortalOwner().length() == 0) {
            res.sendRedirect(req.getContextPath());
            return;
        }
        WebuiRequestContext.setCurrentInstance((RequestContext)context);
        List lifecycles = app.getApplicationLifecycle();
        try {
            for (ApplicationLifecycle lifecycle : lifecycles) {
                lifecycle.onStartRequest((Application)app, (RequestContext)context);
            }
            UIApplication uiApp = app.getStateManager().restoreUIRootComponent((WebuiRequestContext)context);
            if (context.getUIApplication() != uiApp) {
                context.setUIApplication(uiApp);
            }
            if (uiApp != null) {
                uiApp.processDecode((WebuiRequestContext)context);
            }
            if (!context.isResponseComplete() && !context.getProcessRender()) {
                uiApp.processAction((WebuiRequestContext)context);
            }
            if (!context.isResponseComplete()) {
                uiApp.processRender((WebuiRequestContext)context);
            }
            if (uiApp != null) {
                uiApp.setLastAccessApplication(System.currentTimeMillis());
            }
            app.getStateManager().storeUIRootComponent((WebuiRequestContext)context);
        }
        catch (Exception ex) {
            log.error((Object)"Error while handling request", (Throwable)ex);
        }
        finally {
            Safe.close((Closeable)context.getWriter());
            try {
                for (ApplicationLifecycle lifecycle : lifecycles) {
                    lifecycle.onEndRequest((Application)app, (RequestContext)context);
                }
            }
            catch (Exception exception) {
                log.error((Object)"Error while ending request on all ApplicationLifecycle", (Throwable)exception);
            }
            WebuiRequestContext.setCurrentInstance(null);
        }
    }
}

