/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.injection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionUtil;
import org.jboss.injection.Injector;
import org.jboss.injection.JndiFieldInjector;
import org.jboss.injection.JndiMethodInjector;
import org.jboss.injection.ServiceRefInjector;
import org.jboss.injection.WebServiceRefHandler;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceRefInjectionHandler<X extends RemoteEnvironment>
extends WebServiceRefHandler<X> {
    private static final Logger log = Logger.getLogger(WebServiceRefInjectionHandler.class);
    private Map<String, ServiceReferenceMetaData> srefMap = new HashMap<String, ServiceReferenceMetaData>();

    public void loadXml(X xml, InjectionContainer container) {
        if (xml == null) {
            return;
        }
        ServiceReferencesMetaData serviceRefs = xml.getServiceReferences();
        if (serviceRefs == null) {
            return;
        }
        for (ServiceReferenceMetaData sref : serviceRefs) {
            log.debug((Object)("service-ref: " + sref));
            if (this.srefMap.get(sref.getServiceRefName()) != null) {
                throw new IllegalStateException("Duplicate <service-ref-name> in " + sref);
            }
            this.srefMap.put(sref.getServiceRefName(), sref);
            String srefName = sref.getServiceRefName();
            String encName = "env/" + srefName;
            AnnotatedElement annotatedElement = sref.getAnnotatedElement();
            if (sref.getInjectionTargets() != null && sref.getInjectionTargets().size() > 0) {
                for (ResourceInjectionTargetMetaData trg : sref.getInjectionTargets()) {
                    annotatedElement = InjectionUtil.findInjectionTarget((ClassLoader)container.getClassloader(), (ResourceInjectionTargetMetaData)trg);
                    this.addInjector(container, encName, annotatedElement);
                    if (container.getEncInjectors().containsKey(srefName)) continue;
                    container.getEncInjectors().put(srefName, new ServiceRefInjector(encName, annotatedElement, sref));
                }
                continue;
            }
            if (container.getEncInjectors().containsKey(srefName)) continue;
            container.getEncInjectors().put(srefName, new ServiceRefInjector(encName, annotatedElement, sref));
        }
    }

    private void addInjector(InjectionContainer container, String encName, AnnotatedElement annotatedElement) {
        JndiMethodInjector jndiInjector = null;
        if (annotatedElement instanceof Method) {
            Method method = (Method)annotatedElement;
            jndiInjector = new JndiMethodInjector(method, encName, container.getEnc());
            this.addInjector(container, method, method.getDeclaringClass(), (Injector)jndiInjector);
        } else if (annotatedElement instanceof Field) {
            Field field = (Field)annotatedElement;
            jndiInjector = new JndiFieldInjector(field, encName, container.getEnc());
            this.addInjector(container, field, field.getDeclaringClass(), (Injector)jndiInjector);
        } else {
            throw new IllegalStateException("Annotated element for '" + encName + "' is niether Method nor Field: " + annotatedElement);
        }
    }

    private void addInjector(InjectionContainer container, AccessibleObject ao, Class<?> declaringClass, Injector injector) {
        if (injector == null) {
            throw new IllegalArgumentException("null injector.");
        }
        HashMap<AccessibleObject, Injector> map = (HashMap<AccessibleObject, Injector>)container.getEncInjections().get(declaringClass.getName());
        if (map == null) {
            map = new HashMap<AccessibleObject, Injector>();
            container.getEncInjections().put(declaringClass.getName(), map);
        }
        map.put(ao, injector);
    }
}

