/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jbossas5.ProfileServiceComponent;
import org.rhq.plugins.jbossas5.util.ConversionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedComponentDiscoveryComponent
implements ResourceDiscoveryComponent<ProfileServiceComponent> {
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ProfileServiceComponent> discoveryContext) {
        Set components;
        ResourceType resourceType = discoveryContext.getResourceType();
        this.log.trace((Object)("Discovering " + resourceType.getName() + " Resources..."));
        ManagementView managementView = ((ProfileServiceComponent)discoveryContext.getParentResourceComponent()).getConnection().getManagementView();
        managementView.load();
        ComponentType componentType = ConversionUtils.getComponentType(resourceType);
        try {
            components = managementView.getComponentsForType(componentType);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to get component types for " + resourceType + ".", e);
        }
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>(components.size());
        for (ManagedComponent component : components) {
            String resourceName = component.getName();
            String resourceKey = componentType.getType() + ":" + componentType.getSubtype() + ":" + resourceName;
            String version = "?";
            DiscoveredResourceDetails resource = new DiscoveredResourceDetails(resourceType, resourceKey, resourceName, version, resourceType.getDescription(), discoveryContext.getDefaultPluginConfiguration(), null);
            resource.getPluginConfiguration().put((Property)new PropertySimple("componentName", (Object)component.getName()));
            discoveredResources.add(resource);
        }
        this.log.trace((Object)("Discovered " + discoveredResources.size() + " " + resourceType.getName() + " Resources."));
        return discoveredResources;
    }
}

