/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.WindowState;
import org.gatein.registration.Consumer;
import org.gatein.registration.ConsumerCapabilities;
import org.gatein.registration.NoSuchRegistrationException;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationStatus;
import org.gatein.registration.RegistrationUtils;
import org.gatein.wsrp.WSRPExceptionFactory;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.producer.RegistrationInterface;
import org.gatein.wsrp.producer.ServiceHandler;
import org.gatein.wsrp.producer.WSRPProducerImpl;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;
import org.oasis.wsrp.v1.InvalidRegistration;
import org.oasis.wsrp.v1.MissingParameters;
import org.oasis.wsrp.v1.ModifyRegistration;
import org.oasis.wsrp.v1.OperationFailed;
import org.oasis.wsrp.v1.Property;
import org.oasis.wsrp.v1.RegistrationContext;
import org.oasis.wsrp.v1.RegistrationData;
import org.oasis.wsrp.v1.RegistrationState;
import org.oasis.wsrp.v1.ReturnAny;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RegistrationHandler
extends ServiceHandler
implements RegistrationInterface {
    RegistrationHandler(WSRPProducerImpl producer) {
        super(producer);
    }

    @Override
    public RegistrationContext register(RegistrationData registrationData) throws MissingParameters, OperationFailed {
        if (this.producer.getProducerRegistrationRequirements().isRegistrationRequired()) {
            Registration registration;
            WSRPExceptionFactory.throwOperationFailedIfValueIsMissing((Object)registrationData, (String)"RegistrationData");
            String consumerName = registrationData.getConsumerName();
            WSRPExceptionFactory.throwMissingParametersIfValueIsMissing((Object)consumerName, (String)"consumer name", (String)"RegistrationData");
            String consumerAgent = registrationData.getConsumerAgent();
            WSRPExceptionFactory.throwMissingParametersIfValueIsMissing((Object)consumerAgent, (String)"consumer agent", (String)"RegistrationData");
            try {
                log.debug("Attempting to register consumer named '" + consumerName + "', agent '" + consumerAgent + "'.");
                RegistrationUtils.validateConsumerAgent(consumerAgent);
                registration = this.producer.getRegistrationManager().addRegistrationTo(consumerName, this.createRegistrationProperties(registrationData), true);
                this.updateRegistrationInformation(registration, registrationData);
            }
            catch (Exception e) {
                String msg = "Could not register consumer named '" + consumerName + "'";
                log.debug(msg, (Throwable)e);
                throw (OperationFailed)WSRPExceptionFactory.throwWSException((String)"OperationFailed", (String)msg, (Throwable)e);
            }
            RegistrationContext registrationContext = WSRPTypeFactory.createRegistrationContext((String)registration.getRegistrationHandle());
            log.debug("Registration completed without error.");
            return registrationContext;
        }
        throw (OperationFailed)WSRPExceptionFactory.throwWSException((String)"OperationFailed", (String)"Registration shouldn't be attempted if registration is not required", null);
    }

    private void updateRegistrationInformation(Registration registration, RegistrationData registrationData) {
        List wsStrings;
        int wsNb;
        registration.setStatus(RegistrationStatus.VALID);
        Consumer consumer = registration.getConsumer();
        consumer.setConsumerAgent(registrationData.getConsumerAgent());
        ConsumerCapabilities capabilities = consumer.getCapabilities();
        List modeStrings = registrationData.getConsumerModes();
        int modesNb = modeStrings.size();
        if (modesNb > 0) {
            ArrayList<Mode> modes = new ArrayList<Mode>(modesNb);
            for (String modeString : modeStrings) {
                modes.add(WSRPUtils.getJSR168PortletModeFromWSRPName((String)modeString));
            }
            capabilities.setSupportedModes(modes);
        }
        if ((wsNb = (wsStrings = registrationData.getConsumerWindowStates()).size()) > 0) {
            ArrayList<WindowState> windowStates = new ArrayList<WindowState>(wsNb);
            for (String wsString : wsStrings) {
                windowStates.add(WSRPUtils.getJSR168WindowStateFromWSRPName((String)wsString));
            }
            capabilities.setSupportedWindowStates(windowStates);
        }
        capabilities.setSupportedUserProfileData(registrationData.getCustomUserProfileData());
        capabilities.setSupportedUserScopes(registrationData.getConsumerUserScopes());
        capabilities.setSupportsGetMethod(registrationData.isMethodGetSupported());
        this.producer.getRegistrationManager().getPersistenceManager().saveChangesTo(consumer);
    }

    @Override
    public ReturnAny deregister(RegistrationContext deregister) throws OperationFailed, InvalidRegistration {
        if (this.producer.getProducerRegistrationRequirements().isRegistrationRequired()) {
            WSRPExceptionFactory.throwOperationFailedIfValueIsMissing((Object)deregister, (String)"RegistrationContext");
            String registrationHandle = deregister.getRegistrationHandle();
            if (ParameterValidation.isNullOrEmpty((String)registrationHandle)) {
                this.throwInvalidRegistrationFault("Null or empty registration handle");
            }
            log.debug("Attempting to deregister registration with handle '" + registrationHandle + "'");
            String msg = "Could not deregister registration with handle '" + registrationHandle + "'";
            try {
                this.producer.getRegistrationManager().removeRegistration(registrationHandle);
            }
            catch (NoSuchRegistrationException e) {
                log.debug(msg, (Throwable)e);
                this.throwInvalidRegistrationFault(e.getLocalizedMessage());
            }
            catch (RegistrationException e) {
                log.debug(msg, (Throwable)e);
                throw (OperationFailed)WSRPExceptionFactory.throwWSException((String)"OperationFailed", (String)msg, (Throwable)e);
            }
            return new ReturnAny();
        }
        throw (OperationFailed)WSRPExceptionFactory.throwWSException((String)"OperationFailed", (String)"Deregistration shouldn't be attempted if registration is not required", null);
    }

    @Override
    public RegistrationState modifyRegistration(ModifyRegistration modifyRegistration) throws MissingParameters, OperationFailed, InvalidRegistration {
        if (this.producer.getProducerRegistrationRequirements().isRegistrationRequired()) {
            WSRPExceptionFactory.throwOperationFailedIfValueIsMissing((Object)modifyRegistration, (String)"ModifyRegistration");
            RegistrationContext registrationContext = modifyRegistration.getRegistrationContext();
            WSRPExceptionFactory.throwMissingParametersIfValueIsMissing((Object)registrationContext, (String)"RegistrationContext", (String)"ModifyRegistration");
            String registrationHandle = registrationContext.getRegistrationHandle();
            if (ParameterValidation.isNullOrEmpty((String)registrationHandle)) {
                this.throwInvalidRegistrationFault("Null or empty registration handle");
            }
            RegistrationData registrationData = modifyRegistration.getRegistrationData();
            WSRPExceptionFactory.throwMissingParametersIfValueIsMissing((Object)registrationData, (String)"RegistrationData", (String)"ModifyRegistration");
            String consumerName = registrationData.getConsumerName();
            WSRPExceptionFactory.throwMissingParametersIfValueIsMissing((Object)consumerName, (String)"consumer name", (String)"RegistrationData");
            String consumerAgent = registrationData.getConsumerAgent();
            WSRPExceptionFactory.throwMissingParametersIfValueIsMissing((Object)consumerAgent, (String)"consumer agent", (String)"RegistrationData");
            log.debug("Attempting to modify registration with handle '" + registrationHandle + "'");
            String msg = "Could not modify registration with handle '" + registrationHandle + "'";
            try {
                Registration registration = this.producer.getRegistrationManager().getRegistration(registrationHandle);
                Map<QName, Object> properties = this.createRegistrationProperties(registrationData);
                ProducerRegistrationRequirements req = this.producer.getProducerRegistrationRequirements();
                req.getPolicy().validateRegistrationDataFor(properties, consumerName);
                registration.updateProperties(properties);
                this.updateRegistrationInformation(registration, registrationData);
            }
            catch (NoSuchRegistrationException e) {
                log.debug(msg, (Throwable)e);
                this.throwInvalidRegistrationFault(e.getLocalizedMessage());
            }
            catch (RegistrationException e) {
                log.debug(msg, (Throwable)e);
                throw (OperationFailed)WSRPExceptionFactory.throwWSException((String)"OperationFailed", (String)msg, (Throwable)e);
            }
            log.debug("Modified registration with handle '" + registrationHandle + "'");
            return null;
        }
        throw (OperationFailed)WSRPExceptionFactory.throwWSException((String)"OperationFailed", (String)"Modifying a registration shouldn't be attempted if registration is not required", null);
    }

    boolean isRegistrationValid(Registration reg, boolean throwExceptionIfInvalid) throws InvalidRegistration, OperationFailed {
        if (reg == null) {
            if (this.producer.getProducerRegistrationRequirements().isRegistrationRequired()) {
                log.debug("Registration is required yet no RegistrationContext was provided: registration invalid!");
                if (throwExceptionIfInvalid) {
                    this.throwInvalidRegistrationFault("registration is required yet no RegistrationContext was provided!");
                }
                return false;
            }
            log.debug("Registration not required, no registration: registration valid!");
            return true;
        }
        boolean isValid = RegistrationStatus.VALID.equals(reg.getStatus());
        boolean isPending = RegistrationStatus.PENDING.equals(reg.getStatus());
        log.debug("Registration required: registration is " + (isValid ? "valid!" : (isPending ? "pending!" : "invalid!")));
        if (throwExceptionIfInvalid) {
            if (isPending) {
                this.throwOperationFailedFault("Registration with handle '" + reg.getRegistrationHandle() + "' is pending. Consumer needs to call modifyRegistration().", null);
            } else if (!isValid) {
                this.throwInvalidRegistrationFault("registration with handle '" + reg.getRegistrationHandle() + "' is not valid!");
            }
        }
        return isValid;
    }

    Registration getRegistrationFrom(RegistrationContext registrationContext) throws InvalidRegistration, OperationFailed {
        if (this.producer.getProducerRegistrationRequirements().isRegistrationRequired()) {
            String regHandle;
            if (registrationContext == null) {
                this.throwInvalidRegistrationFault("registration context is missing but registration is required");
            }
            if ((regHandle = registrationContext.getRegistrationHandle()) == null) {
                this.throwInvalidRegistrationFault("registration handle is missing but registration is required");
            }
            try {
                Registration registration = this.producer.getRegistrationManager().getRegistration(regHandle);
                if (registration == null) {
                    this.throwInvalidRegistrationFault("provided registration handle '" + regHandle + "' is not registered with this producer");
                }
                return registration;
            }
            catch (RegistrationException e) {
                this.throwOperationFailedFault("Failed to retrieve registration information associated with handle " + regHandle, e);
                return null;
            }
        }
        if (registrationContext != null) {
            this.throwInvalidRegistrationFault("no registration necessary yet one was provided!");
        }
        return null;
    }

    private void throwOperationFailedFault(String message, RegistrationException e) throws OperationFailed {
        throw (OperationFailed)WSRPExceptionFactory.throwWSException((String)"OperationFailed", (String)message, (Throwable)e);
    }

    boolean throwInvalidRegistrationFault(String message) throws InvalidRegistration {
        throw (InvalidRegistration)WSRPExceptionFactory.throwWSException((String)"InvalidRegistration", (String)("Invalid registration: " + message), null);
    }

    private Map<QName, Object> createRegistrationProperties(RegistrationData registrationData) {
        Map<QName, Object> properties;
        List regProperties = registrationData.getRegistrationProperties();
        if (regProperties != null && !regProperties.isEmpty()) {
            properties = new HashMap<QName, Object>(regProperties.size());
            for (Property property : regProperties) {
                QName propName = new QName(property.getName());
                String propValue = property.getStringValue();
                if (this.producer.getProducerRegistrationRequirements().acceptValueFor(propName, (Object)propValue)) {
                    properties.put(propName, propValue);
                    continue;
                }
                throw new IllegalArgumentException("Registration properties named '" + propName + "' with value '" + propValue + "' was rejected by the WSRP producer.");
            }
        } else {
            properties = Collections.emptyMap();
        }
        return properties;
    }

    private List getListFromArray(String[] array, boolean useEmptyForNull) {
        if (array == null) {
            return useEmptyForNull ? Collections.EMPTY_LIST : null;
        }
        return Arrays.asList(array);
    }
}

