/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.interceptors.dynamic;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.array.ArrayElementReadInvocation;
import org.jboss.aop.array.ArrayElementWriteInvocation;
import org.jboss.aop.array.ArrayRegistry;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.cache.pojo.collection.CachedArray;
import org.jboss.cache.pojo.collection.CachedArrayRegistry;

public class ArrayInterceptor
implements Interceptor {
    public String getName() {
        return this.getClass().getName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        ArrayElementWriteInvocation write;
        Object array;
        CachedArray cached;
        if (invocation instanceof ArrayElementReadInvocation) {
            ArrayElementReadInvocation read = (ArrayElementReadInvocation)invocation;
            Object array2 = read.getTargetObject();
            CachedArray cached2 = CachedArrayRegistry.lookup(array2);
            if (cached2 != null) {
                int index = read.getIndex();
                Object element = cached2.get(index);
                if (element != null && element.getClass().isArray()) {
                    ArrayRegistry.getInstance().addElementReference(array2, index, element);
                }
                return element;
            }
        } else if (invocation instanceof ArrayElementWriteInvocation && (cached = CachedArrayRegistry.lookup(array = (write = (ArrayElementWriteInvocation)invocation).getTargetObject())) != null) {
            cached.set(write.getIndex(), write.getValue());
            return null;
        }
        return invocation.invokeNext();
    }
}

