/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.pool;

import java.util.LinkedList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.ejb.EJBException;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.pool.AbstractPool;
import org.jboss.logging.Logger;

public class StrictMaxPool
extends AbstractPool {
    public static final int DEFAULT_MAX_SIZE = 30;
    public static final long DEFAULT_TIMEOUT = Long.MAX_VALUE;
    private Semaphore strictMaxSize;
    private int inUse = 0;
    private long strictTimeout;
    protected LinkedList pool = new LinkedList();
    protected int maxSize = 30;
    Logger log = Logger.getLogger(StrictMaxPool.class);

    public void initialize(Container container, int maxSize, long timeout) {
        super.initialize(container, maxSize, timeout);
        this.maxSize = maxSize;
        this.strictMaxSize = new Semaphore(maxSize, true);
        this.strictTimeout = timeout;
    }

    public int getCurrentSize() {
        return this.getCreateCount() - this.getRemoveCount();
    }

    public int getAvailableCount() {
        return this.maxSize - this.inUse;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        this.strictMaxSize = new Semaphore(maxSize, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanContext get() {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("Get instance " + this + "#" + this.pool.size() + "#" + this.container.getBeanClass()));
        }
        try {
            boolean acquired = this.strictMaxSize.tryAcquire(this.strictTimeout, TimeUnit.MILLISECONDS);
            if (trace) {
                this.log.trace((Object)("Acquired(" + acquired + ") strictMaxSize semaphore, remaining=" + this.strictMaxSize.availablePermits()));
            }
            if (!acquired) {
                throw new EJBException("Failed to acquire the pool semaphore, strictTimeout=" + this.strictTimeout);
            }
        }
        catch (InterruptedException e) {
            throw new EJBException("Pool strictMaxSize semaphore was interrupted");
        }
        LinkedList linkedList = this.pool;
        synchronized (linkedList) {
            if (!this.pool.isEmpty()) {
                BeanContext bean = (BeanContext)this.pool.removeFirst();
                ++this.inUse;
                return bean;
            }
        }
        ++this.inUse;
        return this.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanContext get(Class[] initTypes, Object[] initValues) {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("Get instance " + this + "#" + this.pool.size() + "#" + this.container.getBeanClass()));
        }
        try {
            boolean acquired = this.strictMaxSize.tryAcquire(this.strictTimeout, TimeUnit.MILLISECONDS);
            if (trace) {
                this.log.trace((Object)("Acquired(" + acquired + ") strictMaxSize semaphore, remaining=" + this.strictMaxSize.availablePermits()));
            }
            if (!acquired) {
                throw new EJBException("Failed to acquire the pool semaphore, strictTimeout=" + this.strictTimeout);
            }
        }
        catch (InterruptedException e) {
            throw new EJBException("Pool strictMaxSize semaphore was interrupted");
        }
        LinkedList linkedList = this.pool;
        synchronized (linkedList) {
            if (!this.pool.isEmpty()) {
                BeanContext bean = (BeanContext)this.pool.removeFirst();
                ++this.inUse;
                return bean;
            }
        }
        ++this.inUse;
        return this.create(initTypes, initValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(BeanContext ctx) {
        if (this.log.isTraceEnabled()) {
            String msg = this.pool.size() + "/" + this.maxSize + " Free instance:" + this + "#" + this.container.getBeanClass();
            this.log.trace((Object)msg);
        }
        try {
            boolean removeIt = false;
            LinkedList linkedList = this.pool;
            synchronized (linkedList) {
                if (this.pool.size() < this.maxSize) {
                    this.pool.addFirst(ctx);
                } else {
                    removeIt = true;
                }
            }
            if (removeIt) {
                this.remove(ctx);
            }
            this.strictMaxSize.release();
            --this.inUse;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() {
        this.freeAll();
    }

    public void discard(BeanContext ctx) {
        if (this.log.isTraceEnabled()) {
            String msg = "Discard instance:" + this + "#" + ctx + "#" + this.container.getBeanClass();
            this.log.trace((Object)msg);
        }
        this.strictMaxSize.release();
        --this.inUse;
        super.discard(ctx);
    }

    private void freeAll() {
        LinkedList clone = (LinkedList)this.pool.clone();
        for (int i = 0; i < clone.size(); ++i) {
            BeanContext bc = (BeanContext)clone.get(i);
            this.discard(bc);
        }
        this.pool.clear();
        this.inUse = 0;
    }

    public void remove(BeanContext ctx) {
        if (this.log.isTraceEnabled()) {
            String msg = "Removing instance:" + this + "#" + ctx + "#" + this.container.getBeanClass();
            this.log.trace((Object)msg);
        }
        this.strictMaxSize.release();
        --this.inUse;
        super.remove(ctx);
    }
}

