/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployment;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.management.ObjectName;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.resource.metadata.AdminObjectMetaData;
import org.jboss.resource.metadata.ConfigPropertyMetaData;

public class AdminObjectFactory {
    private static final Logger log = Logger.getLogger(AdminObjectFactory.class);

    public static Object createAdminObject(String jndiName, ObjectName rarName, AdminObjectMetaData aomd, Properties properties) throws Exception {
        String value;
        String name;
        Collection<ConfigPropertyMetaData> raProperties;
        Class<?> implClass;
        boolean trace = log.isTraceEnabled();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (trace) {
            log.trace((Object)("Creating AdminObject '" + jndiName + "' metadata=" + aomd + " rar=" + rarName + " properties=" + properties + " classloader=" + cl));
        }
        String interfaceName = aomd.getAdminObjectInterfaceClass();
        if (trace) {
            log.trace((Object)("AdminObject '" + jndiName + "' loading interface=" + interfaceName));
        }
        Class<?> interfaceClass = cl.loadClass(interfaceName);
        String implName = aomd.getAdminObjectImplementationClass();
        if (implName == null) {
            throw new DeploymentException("No implementation class for admin object '" + interfaceClass + "' ra=" + rarName);
        }
        if (trace) {
            log.trace((Object)("AdminObject '" + jndiName + "' loading implementation=" + implName));
        }
        if (!interfaceClass.isAssignableFrom(implClass = cl.loadClass(implName))) {
            throw new DeploymentException(implClass.getName() + " is not a '" + interfaceClass + "' ra=" + rarName);
        }
        Object result = implClass.newInstance();
        if (trace) {
            log.trace((Object)("AdminObject '" + jndiName + "' created instance=" + result));
        }
        if ((raProperties = aomd.getProperties()) != null && raProperties.size() != 0) {
            for (ConfigPropertyMetaData configPropertyMetaData : raProperties) {
                Class<?> type;
                PropertyEditor editor;
                name = configPropertyMetaData.getName();
                value = configPropertyMetaData.getValue();
                if (value == null || value.length() <= 0) continue;
                if (properties.containsKey(name)) {
                    if (!trace) continue;
                    log.trace((Object)("AdminObject '" + jndiName + "' property=" + name + " IGNORING value=" + value + " specified in MBean properties."));
                    continue;
                }
                String typeName = configPropertyMetaData.getType();
                if (trace) {
                    log.trace((Object)("AdminObject '" + jndiName + "' property=" + name + " loading class=" + typeName));
                }
                if ((editor = PropertyEditorManager.findEditor(type = cl.loadClass(typeName))) == null) {
                    throw new DeploymentException("No property editor found for property '" + name + " class='" + type + "' for admin object '" + interfaceClass + "' ra=" + rarName);
                }
                editor.setAsText(value);
                Object object = editor.getValue();
                try {
                    String setter = "set" + Character.toUpperCase(name.charAt(0));
                    if (name.length() > 1) {
                        setter = setter.concat(name.substring(1));
                    }
                    Method method = implClass.getMethod(setter, type);
                    if (trace) {
                        log.trace((Object)("AdminObject '" + jndiName + "' property=" + name + " set=" + object));
                    }
                    method.invoke(result, object);
                }
                catch (InvocationTargetException e) {
                    DeploymentException.rethrowAsDeploymentException((String)("Error for property '" + name + "' class=" + implClass + "' for admin object '" + interfaceClass + "' ra=" + rarName), (Throwable)e.getTargetException());
                }
                catch (Throwable t) {
                    DeploymentException.rethrowAsDeploymentException((String)("Error for property '" + name + "' class=" + implClass + "' for admin object '" + interfaceClass + "' ra=" + rarName), (Throwable)t);
                }
            }
        }
        if (properties != null) {
            for (Map.Entry entry : properties.entrySet()) {
                Class<?> type;
                PropertyEditor editor;
                ConfigPropertyMetaData cpmd;
                name = (String)entry.getKey();
                value = (String)entry.getValue();
                if (trace) {
                    log.trace((Object)("AdminObject '" + jndiName + "' property=" + name + " value=" + value));
                }
                if ((cpmd = aomd.getProperty(name)) == null) {
                    throw new DeploymentException("No property '" + name + "' for admin object '" + interfaceClass + "' ra=" + rarName);
                }
                if (trace) {
                    log.trace((Object)("AdminObject '" + jndiName + "' property=" + name + " metadata=" + cpmd));
                }
                String typeName = cpmd.getType();
                if (trace) {
                    log.trace((Object)("AdminObject '" + jndiName + "' property=" + name + " loading class=" + typeName));
                }
                if ((editor = PropertyEditorManager.findEditor(type = cl.loadClass(typeName))) == null) {
                    throw new DeploymentException("No property editor found for property '" + name + " class='" + type + "' for admin object '" + interfaceClass + "' ra=" + rarName);
                }
                editor.setAsText(value);
                Object object = editor.getValue();
                try {
                    String setter = "set" + Character.toUpperCase(name.charAt(0));
                    if (name.length() > 1) {
                        setter = setter.concat(name.substring(1));
                    }
                    Method method = implClass.getMethod(setter, type);
                    if (trace) {
                        log.trace((Object)("AdminObject '" + jndiName + "' property=" + name + " set=" + object));
                    }
                    method.invoke(result, object);
                }
                catch (InvocationTargetException e) {
                    DeploymentException.rethrowAsDeploymentException((String)("Error for property '" + name + "' class=" + implClass + "' for admin object '" + interfaceClass + "' ra=" + rarName), (Throwable)e.getTargetException());
                }
                catch (Throwable t) {
                    DeploymentException.rethrowAsDeploymentException((String)("Error for property '" + name + "' class=" + implClass + "' for admin object '" + interfaceClass + "' ra=" + rarName), (Throwable)t);
                }
            }
        }
        return result;
    }
}

