/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.cache.CacheManager;
import org.jboss.logging.Logger;

public class CacheManagerLocator {
    private static final Logger log = Logger.getLogger(CacheManagerLocator.class);
    private static CacheManagerLocator sharedInstance = new CacheManagerLocator();
    public static final String STANDARD_JNDI_NAME = "java:CacheManager";
    private CacheManager registeredManager;

    public static CacheManagerLocator getCacheManagerLocator() {
        return sharedInstance;
    }

    protected static void setSharedInstance(CacheManagerLocator shared) {
        if (shared == null) {
            throw new IllegalArgumentException("shared cannot be null");
        }
        sharedInstance = shared;
    }

    protected CacheManagerLocator() {
    }

    public CacheManager getCacheManager(Hashtable jndiProperties) {
        CacheManager manager = this.registeredManager;
        if (manager == null) {
            try {
                manager = this.findInJndi(jndiProperties);
            }
            catch (NamingException e) {
                log.error((Object)"Problem finding CacheManager in JNDI", (Throwable)e);
            }
        }
        if (manager == null) {
            throw new IllegalStateException("CacheManager not found");
        }
        return manager;
    }

    public void registerCacheManager(CacheManager manager) {
        if (manager != null) {
            if (this.registeredManager != null && manager != this.registeredManager) {
                throw new IllegalStateException("CacheManager already registered");
            }
            this.registeredManager = manager;
        }
    }

    public CacheManager getDirectlyRegisteredManager() {
        return this.registeredManager;
    }

    public void deregisterCacheManager() {
        this.registeredManager = null;
    }

    protected CacheManager findInJndi(Hashtable jndiProperties) throws NamingException {
        try {
            InitialContext ctx = new InitialContext(jndiProperties);
            return (CacheManager)ctx.lookup(STANDARD_JNDI_NAME);
        }
        catch (NameNotFoundException e) {
            return null;
        }
    }
}

