/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.inventory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.metadata.PluginMetadataManager;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.inventory.ResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InventoryFile {
    private Log log = LogFactory.getLog(InventoryFile.class);
    private final File inventoryFile;
    private Resource platform;
    private Map<String, ResourceContainer> resourceContainers;

    public InventoryFile(File inventoryFile) {
        this.inventoryFile = inventoryFile;
    }

    public File getInventoryFile() {
        return this.inventoryFile;
    }

    public Resource getPlatform() {
        return this.platform;
    }

    public Map<String, ResourceContainer> getResourceContainers() {
        return this.resourceContainers;
    }

    public void loadInventory() throws PluginContainerException {
        try {
            FileInputStream fis = new FileInputStream(this.inventoryFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.platform = (Resource)ois.readObject();
            this.connectTypes(this.platform);
            this.resourceContainers = (Map)ois.readObject();
            for (ResourceContainer resourceContainer : this.resourceContainers.values()) {
                this.connectTypes(resourceContainer.getResource());
            }
        }
        catch (Exception e) {
            throw new PluginContainerException("Cannot load inventory file: " + this.inventoryFile, (Throwable)e);
        }
    }

    private void connectTypes(Resource resource) {
        PluginMetadataManager metadataManager = PluginContainer.getInstance().getPluginManager().getMetadataManager();
        ResourceType resourceType = resource.getResourceType();
        if (resourceType != null) {
            ResourceType fullResourceType = metadataManager.getType(resourceType);
            resource.setResourceType(fullResourceType);
        } else {
            this.log.error((Object)("Resource [" + resource + "] has a null resource type - cannot reconnect the type"));
        }
        Set children = resource.getChildResources();
        if (children != null) {
            for (Resource child : children) {
                this.connectTypes(child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeInventory(Resource platformResource, Map<String, ResourceContainer> containers) throws IOException {
        FileOutputStream fos = new FileOutputStream(this.inventoryFile);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(platformResource);
            oos.writeObject(containers);
            this.platform = platformResource;
            this.resourceContainers = containers;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

