/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.addressing;

import com.sun.istack.NotNull;
import com.sun.xml.ws.addressing.WsaPropertyBag;
import com.sun.xml.ws.addressing.WsaTube;
import com.sun.xml.ws.addressing.model.ActionNotSupportedException;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.resources.AddressingMessages;
import javax.xml.ws.WebServiceException;

public final class WsaClientTube
extends WsaTube {
    public WsaClientTube(WSDLPort wsdlPort, WSBinding binding, Tube next) {
        super(wsdlPort, binding, next);
    }

    public WsaClientTube(WsaClientTube that, TubeCloner cloner) {
        super(that, cloner);
    }

    public WsaClientTube copy(TubeCloner cloner) {
        return new WsaClientTube(this, cloner);
    }

    @NotNull
    public NextAction processRequest(Packet request) {
        return this.doInvoke(this.next, request);
    }

    @NotNull
    public NextAction processResponse(Packet response) {
        if (response.getMessage() != null) {
            response = this.validateInboundHeaders(response);
            response.addSatellite(new WsaPropertyBag(this.addressingVersion, this.soapVersion, response));
        }
        return this.doReturnWith(response);
    }

    public void validateAction(Packet packet) {
        WSDLBoundOperation wbo = this.getWSDLBoundOperation(packet);
        if (wbo == null) {
            return;
        }
        String gotA = packet.getMessage().getHeaders().getAction(this.addressingVersion, this.soapVersion);
        if (gotA == null) {
            throw new WebServiceException(AddressingMessages.VALIDATION_CLIENT_NULL_ACTION());
        }
        String expected = this.helper.getOutputAction(packet);
        if (expected != null && !gotA.equals(expected)) {
            throw new ActionNotSupportedException(gotA);
        }
    }

    protected void checkMandatoryHeaders(Packet packet, boolean foundAction, boolean foundTo, boolean foundMessageID, boolean foundRelatesTo) {
        super.checkMandatoryHeaders(packet, foundAction, foundTo, foundMessageID, foundRelatesTo);
    }
}

