/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.jms.exception.MessagingJMSException;
import org.jboss.jms.message.BytesMessageProxy;
import org.jboss.jms.message.JBossBytesMessage;
import org.jboss.jms.message.JBossMapMessage;
import org.jboss.jms.message.JBossObjectMessage;
import org.jboss.jms.message.JBossStreamMessage;
import org.jboss.jms.message.JBossTextMessage;
import org.jboss.jms.message.MapMessageProxy;
import org.jboss.jms.message.MessageProxy;
import org.jboss.jms.message.ObjectMessageProxy;
import org.jboss.jms.message.StreamMessageProxy;
import org.jboss.jms.message.TextMessageProxy;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.impl.message.MessageSupport;
import org.jboss.util.Primitives;
import org.jboss.util.Strings;

public class JBossMessage
extends MessageSupport
implements Message,
Serializable {
    private static final long serialVersionUID = 2833181306818971346L;
    public static final byte TYPE = 1;
    private static final char PROPERTY_PREFIX_CHAR = 'P';
    private static final String PROPERTY_PREFIX = "P";
    private static final String DESTINATION_HEADER_NAME = "H.DEST";
    private static final String REPLYTO_HEADER_NAME = "H.REPLYTO";
    private static final String CORRELATIONID_HEADER_NAME = "H.CORRELATIONID";
    private static final String JBM_MESSAGE_ID = "JBM_MESSAGE_ID";
    private static final String CORRELATIONIDBYTES_HEADER_NAME = "H.CORRELATIONIDBYTES";
    private static final String TYPE_HEADER_NAME = "H.TYPE";
    public static final String JMS_JBOSS_SCHEDULED_DELIVERY_PROP_NAME = "JMS_JBOSS_SCHEDULED_DELIVERY";
    public static final String JBOSS_MESSAGING_ORIG_DESTINATION = "JBM_ORIG_DESTINATION";
    public static final String JBOSS_MESSAGING_ORIG_MESSAGE_ID = "JBM_ORIG_MESSAGE_ID";
    public static final String JBOSS_MESSAGING_ORIG_DESTINATION_SUCKER = "JBM_ORIG_DESTINATION_SUCKER";
    public static final String JBOSS_MESSAGING_ACTUAL_EXPIRY_TIME = "JBM_ACTUAL_EXPIRY";
    public static final String JBOSS_MESSAGING_BRIDGE_MESSAGE_ID_LIST = "JBM_BRIDGE_MSG_ID_LIST";
    private static final Logger log = Logger.getLogger(JBossMessage.class);
    private static final HashSet reservedIdentifiers = new HashSet();
    protected transient String connectionID;
    private long scheduledDeliveryTime;
    private Destination destination;

    public static MessageProxy createThinDelegate(long deliveryId, JBossMessage m, int deliveryCount) {
        MessageProxy del = m instanceof BytesMessage ? new BytesMessageProxy(deliveryId, (JBossBytesMessage)m, deliveryCount) : (m instanceof MapMessage ? new MapMessageProxy(deliveryId, (JBossMapMessage)m, deliveryCount) : (m instanceof ObjectMessage ? new ObjectMessageProxy(deliveryId, (JBossObjectMessage)m, deliveryCount) : (m instanceof StreamMessage ? new StreamMessageProxy(deliveryId, (JBossStreamMessage)m, deliveryCount) : (m instanceof TextMessage ? new TextMessageProxy(deliveryId, (JBossTextMessage)m, deliveryCount) : new MessageProxy(deliveryId, m, deliveryCount)))));
        return del;
    }

    public static String dump(JBossMessage m) {
        String type = null;
        type = m instanceof BytesMessage ? "Bytes" : (m instanceof MapMessage ? "Map" : (m instanceof ObjectMessage ? "Object" : (m instanceof StreamMessage ? "Stream" : (m instanceof TextMessage ? "Text" : "Generic"))));
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append("         MESSAGE DUMP\n");
        sb.append("              Core ID:       ").append(m.messageID).append('\n');
        sb.append("              reliable:      ").append(m.reliable).append('\n');
        sb.append("              expiration:    ").append(m.expiration).append('\n');
        sb.append("              timestamp:     ").append(m.timestamp).append('\n');
        sb.append("              headers:       ");
        if (m.headers.size() == 0) {
            sb.append("NO HEADERS").append('\n');
        } else {
            sb.append('\n');
            for (String name : m.headers.keySet()) {
                sb.append("                             ");
                sb.append(name).append(" - ").append(m.headers.get(name)).append('\n');
            }
        }
        int deliveryCount = 0;
        try {
            deliveryCount = m.getIntProperty("JMSXDeliveryCount");
        }
        catch (JMSException e) {
            log.error((Object)"Failed to get delivery count", (Throwable)e);
        }
        try {
            sb.append("              redelivered:   ").append(deliveryCount >= 1).append('\n');
            sb.append("              priority:      ").append(m.priority).append('\n');
            sb.append("              deliveryCount: ").append(deliveryCount).append('\n');
            sb.append("              JMS ID:        ").append(m.getJMSMessageID()).append('\n');
            sb.append("              type:          ").append(type).append('\n');
            sb.append("              destination:   ").append(m.getJMSDestination()).append('\n');
            sb.append("              replyTo:       ").append(m.getJMSReplyTo()).append('\n');
            sb.append("              jmsType:       ").append(m.getJMSType()).append('\n');
            sb.append("              properties:    ");
        }
        catch (Exception e) {
            log.error((Object)"Failed to dump message", (Throwable)e);
        }
        Iterator iter = m.headers.entrySet().iterator();
        int count = 0;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String propName = (String)entry.getKey();
            if (propName.charAt(0) != 'P') continue;
            if (count == 0) {
                sb.append("\n");
            }
            sb.append("                             ");
            sb.append(propName).append(" - ").append(entry.getValue()).append('\n');
            ++count;
        }
        sb.append("\n");
        return sb.toString();
    }

    public JBossMessage() {
    }

    public JBossMessage(long messageID) {
        super(messageID, true, 0L, System.currentTimeMillis(), (byte)4, null, null);
    }

    public JBossMessage(long messageID, boolean reliable, long expiration, long timestamp, byte priority, Map headers, byte[] payloadAsByteArray) {
        super(messageID, reliable, expiration, timestamp, priority, headers, payloadAsByteArray);
    }

    protected JBossMessage(JBossMessage other) {
        super(other);
        this.connectionID = other.connectionID;
        this.scheduledDeliveryTime = other.scheduledDeliveryTime;
        this.destination = other.destination;
    }

    public JBossMessage(Message foreign, long messageID) throws JMSException {
        block3: {
            super(messageID);
            this.setJMSTimestamp(foreign.getJMSTimestamp());
            try {
                byte[] corrIDBytes = foreign.getJMSCorrelationIDAsBytes();
                this.setJMSCorrelationIDAsBytes(corrIDBytes);
            }
            catch (JMSException e) {
                String corrIDString = foreign.getJMSCorrelationID();
                if (corrIDString == null) break block3;
                this.setJMSCorrelationID(corrIDString);
            }
        }
        this.setJMSReplyTo(foreign.getJMSReplyTo());
        this.setJMSDestination(foreign.getJMSDestination());
        this.setJMSDeliveryMode(foreign.getJMSDeliveryMode());
        this.setJMSExpiration(foreign.getJMSExpiration());
        this.setJMSPriority(foreign.getJMSPriority());
        this.setJMSType(foreign.getJMSType());
        Enumeration props = foreign.getPropertyNames();
        while (props.hasMoreElements()) {
            String name = (String)props.nextElement();
            Object prop = foreign.getObjectProperty(name);
            this.setObjectProperty(name, prop);
        }
    }

    public boolean isReference() {
        return false;
    }

    public String getJMSMessageID() {
        return (String)this.headers.get(JBM_MESSAGE_ID);
    }

    public void setJMSMessageID(String jmsMessageID) throws JMSException {
        if (jmsMessageID != null && !jmsMessageID.startsWith("ID:")) {
            throw new JMSException("JMSMessageID must start with ID:");
        }
        this.headers.put(JBM_MESSAGE_ID, jmsMessageID);
    }

    public long getJMSTimestamp() throws JMSException {
        return this.timestamp;
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.timestamp = timestamp;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return (byte[])this.headers.get(CORRELATIONIDBYTES_HEADER_NAME);
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        if (correlationID == null || correlationID.length == 0) {
            throw new JMSException("Please specify a non-zero length byte[]");
        }
        this.headers.put(CORRELATIONIDBYTES_HEADER_NAME, correlationID);
        this.headers.remove(CORRELATIONID_HEADER_NAME);
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this.headers.put(CORRELATIONID_HEADER_NAME, correlationID);
        this.headers.remove(CORRELATIONIDBYTES_HEADER_NAME);
    }

    public String getJMSCorrelationID() throws JMSException {
        return (String)this.headers.get(CORRELATIONID_HEADER_NAME);
    }

    public Destination getJMSReplyTo() throws JMSException {
        return (Destination)this.headers.get(REPLYTO_HEADER_NAME);
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        this.headers.put(REPLYTO_HEADER_NAME, replyTo);
    }

    public Destination getJMSDestination() throws JMSException {
        if (this.destination != null) {
            return this.destination;
        }
        return (Destination)this.headers.get(DESTINATION_HEADER_NAME);
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.destination = destination;
    }

    public Map getHeaders() {
        if (this.destination != null) {
            this.headers.put(DESTINATION_HEADER_NAME, this.destination);
        }
        this.destination = null;
        return this.headers;
    }

    public Destination getOriginalSuckerDestination() {
        return (Destination)this.headers.get(JBOSS_MESSAGING_ORIG_DESTINATION_SUCKER);
    }

    public void setOriginalSuckerDestination(Destination destination) {
        this.headers.put(JBOSS_MESSAGING_ORIG_DESTINATION_SUCKER, destination);
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.reliable ? 2 : 1;
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        if (deliveryMode == 2) {
            this.reliable = true;
        } else if (deliveryMode == 1) {
            this.reliable = false;
        } else {
            throw new MessagingJMSException("Delivery mode must be either DeliveryMode.PERSISTENT or DeliveryMode.NON_PERSISTENT");
        }
    }

    public boolean getJMSRedelivered() throws JMSException {
        throw new IllegalStateException("This should never be called directly");
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        throw new IllegalStateException("This should never be called directly");
    }

    public String getJMSType() throws JMSException {
        return (String)this.headers.get(TYPE_HEADER_NAME);
    }

    public void setJMSType(String type) throws JMSException {
        this.headers.put(TYPE_HEADER_NAME, type);
    }

    public long getJMSExpiration() throws JMSException {
        return this.expiration;
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.expiration = expiration;
    }

    public int getJMSPriority() throws JMSException {
        return this.priority;
    }

    public void setJMSPriority(int priority) throws JMSException {
        this.priority = (byte)priority;
    }

    public void clearProperties() throws JMSException {
        Iterator iter = this.headers.keySet().iterator();
        while (iter.hasNext()) {
            String propName = (String)iter.next();
            if (propName.charAt(0) != 'P') continue;
            iter.remove();
        }
    }

    public void clearBody() throws JMSException {
        this.payload = null;
        this.payloadAsByteArray = null;
    }

    public boolean propertyExists(String name) throws JMSException {
        return this.headers.containsKey(PROPERTY_PREFIX + name) || name.equals("JMSXDeliveryCount");
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        Object value = this.headers.get(PROPERTY_PREFIX + name);
        if (value == null) {
            return Boolean.valueOf(null);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public byte getByteProperty(String name) throws JMSException {
        Object value = this.headers.get(PROPERTY_PREFIX + name);
        if (value == null) {
            throw new NumberFormatException("Message property '" + name + "' not set.");
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            return Byte.parseByte((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public short getShortProperty(String name) throws JMSException {
        Object value = this.headers.get(PROPERTY_PREFIX + name);
        if (value == null) {
            throw new NumberFormatException("Message property '" + name + "' not set.");
        }
        if (value instanceof Byte) {
            return ((Byte)value).shortValue();
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            return Short.parseShort((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public int getIntProperty(String name) throws JMSException {
        Object value = this.headers.get(PROPERTY_PREFIX + name);
        if (value == null) {
            throw new NumberFormatException("Message property '" + name + "' not set.");
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public long getLongProperty(String name) throws JMSException {
        if (JMS_JBOSS_SCHEDULED_DELIVERY_PROP_NAME.equals(name)) {
            if (this.scheduledDeliveryTime == 0L) {
                throw new NumberFormatException("Message property '" + name + "' not set.");
            }
            return this.scheduledDeliveryTime;
        }
        Object value = this.headers.get(PROPERTY_PREFIX + name);
        if (value == null) {
            throw new NumberFormatException("Message property '" + name + "' not set.");
        }
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public float getFloatProperty(String name) throws JMSException {
        Object value = this.headers.get(PROPERTY_PREFIX + name);
        if (value == null) {
            return Float.valueOf(null).floatValue();
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String) {
            return Float.parseFloat((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public double getDoubleProperty(String name) throws JMSException {
        Object value = this.headers.get(PROPERTY_PREFIX + name);
        if (value == null) {
            return Double.valueOf(null);
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public String getStringProperty(String name) throws JMSException {
        if (JMS_JBOSS_SCHEDULED_DELIVERY_PROP_NAME.equals(name)) {
            if (this.scheduledDeliveryTime == 0L) {
                throw new NumberFormatException("Message property '" + name + "' not set.");
            }
            return String.valueOf(this.scheduledDeliveryTime);
        }
        Object value = this.headers.get(PROPERTY_PREFIX + name);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Byte) {
            return value.toString();
        }
        if (value instanceof Short) {
            return value.toString();
        }
        if (value instanceof Integer) {
            return value.toString();
        }
        if (value instanceof Long) {
            return value.toString();
        }
        if (value instanceof Float) {
            return value.toString();
        }
        if (value instanceof Double) {
            return value.toString();
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public Object getObjectProperty(String name) throws JMSException {
        if (JMS_JBOSS_SCHEDULED_DELIVERY_PROP_NAME.equals(name)) {
            if (this.scheduledDeliveryTime == 0L) {
                return null;
            }
            return new Long(this.scheduledDeliveryTime);
        }
        return this.headers.get(PROPERTY_PREFIX + name);
    }

    public Enumeration getPropertyNames() throws JMSException {
        HashSet<String> set = new HashSet<String>();
        for (String propName : this.headers.keySet()) {
            if (propName.charAt(0) != 'P') continue;
            String name = propName.substring(1);
            set.add(name);
        }
        if (this.scheduledDeliveryTime != 0L) {
            set.add(JMS_JBOSS_SCHEDULED_DELIVERY_PROP_NAME);
        }
        return Collections.enumeration(set);
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        Boolean b = Primitives.valueOf((boolean)value);
        this.checkProperty(name, b);
        this.headers.put(PROPERTY_PREFIX + name, b);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        Byte b = new Byte(value);
        this.checkProperty(name, b);
        this.headers.put(PROPERTY_PREFIX + name, b);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        Short s = new Short(value);
        this.checkProperty(name, s);
        this.headers.put(PROPERTY_PREFIX + name, s);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        Integer i = new Integer(value);
        this.checkProperty(name, i);
        this.headers.put(PROPERTY_PREFIX + name, i);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        if (JMS_JBOSS_SCHEDULED_DELIVERY_PROP_NAME.equals(name)) {
            this.scheduledDeliveryTime = value;
        } else {
            Long l = new Long(value);
            this.checkProperty(name, l);
            this.headers.put(PROPERTY_PREFIX + name, l);
        }
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        Float f = new Float(value);
        this.checkProperty(name, f);
        this.headers.put(PROPERTY_PREFIX + name, f);
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        Double d = new Double(value);
        this.checkProperty(name, d);
        this.headers.put(PROPERTY_PREFIX + name, d);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.checkProperty(name, value);
        this.headers.put(PROPERTY_PREFIX + name, value);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (JMS_JBOSS_SCHEDULED_DELIVERY_PROP_NAME.equals(name) && value instanceof Long) {
            this.scheduledDeliveryTime = (Long)value;
            return;
        }
        this.checkProperty(name, value);
        if (value instanceof Boolean) {
            this.headers.put(PROPERTY_PREFIX + name, value);
        } else if (value instanceof Byte) {
            this.headers.put(PROPERTY_PREFIX + name, value);
        } else if (value instanceof Short) {
            this.headers.put(PROPERTY_PREFIX + name, value);
        } else if (value instanceof Integer) {
            this.headers.put(PROPERTY_PREFIX + name, value);
        } else if (value instanceof Long) {
            this.headers.put(PROPERTY_PREFIX + name, value);
        } else if (value instanceof Float) {
            this.headers.put(PROPERTY_PREFIX + name, value);
        } else if (value instanceof Double) {
            this.headers.put(PROPERTY_PREFIX + name, value);
        } else if (value instanceof String) {
            this.headers.put(PROPERTY_PREFIX + name, value);
        } else if (value == null) {
            this.headers.put(PROPERTY_PREFIX + name, null);
        } else {
            throw new MessageFormatException("Invalid object type");
        }
    }

    public void doBeforeSend() throws JMSException {
    }

    public void doBeforeReceive() throws JMSException {
    }

    public byte getType() {
        return 1;
    }

    public void copyPayload(Object payload) throws JMSException {
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public void setConnectionID(String connectionID) {
        this.connectionID = connectionID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("JBossMessage[");
        sb.append("");
        sb.append(this.messageID);
        sb.append("]:");
        sb.append(this.isReliable() ? "PERSISTENT" : "NON-PERSISTENT");
        return sb.toString();
    }

    public JBossMessage doCopy() throws JMSException {
        return new JBossMessage(this);
    }

    public void acknowledge() {
        throw new IllegalStateException("Should not be handled here!");
    }

    public void setMessageId(long messageID) {
        this.messageID = messageID;
    }

    public long getScheduledDeliveryTime() {
        return this.scheduledDeliveryTime;
    }

    public Map getJMSProperties() {
        HashMap newHeaders = new HashMap();
        for (Map.Entry entry : this.headers.entrySet()) {
            String key = (String)entry.getKey();
            if (key.charAt(0) != 'P') continue;
            newHeaders.put(key, entry.getValue());
        }
        return newHeaders;
    }

    public boolean isCorrelationIDBytes() {
        return this.headers.get(CORRELATIONIDBYTES_HEADER_NAME) != null;
    }

    public void write(DataOutputStream out) throws Exception {
        super.write(out);
        out.writeLong(this.scheduledDeliveryTime);
        JBossDestination.writeDestination(out, this.destination);
    }

    public void read(DataInputStream in) throws Exception {
        super.read(in);
        this.scheduledDeliveryTime = in.readLong();
        this.destination = JBossDestination.readDestination(in);
    }

    void checkProperty(String name, Object value) throws JMSException {
        if (name == null) {
            throw new IllegalArgumentException("The name of a property must not be null.");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("The name of a property must not be an empty String.");
        }
        if (!Strings.isValidJavaIdentifier((String)name)) {
            throw new IllegalArgumentException("The property name '" + name + "' is not a valid java identifier.");
        }
        if (reservedIdentifiers.contains(name)) {
            throw new IllegalArgumentException("The property name '" + name + "' is reserved due to selector syntax.");
        }
    }

    static {
        reservedIdentifiers.add("NULL");
        reservedIdentifiers.add("TRUE");
        reservedIdentifiers.add("FALSE");
        reservedIdentifiers.add("NOT");
        reservedIdentifiers.add("AND");
        reservedIdentifiers.add("OR");
        reservedIdentifiers.add("BETWEEN");
        reservedIdentifiers.add("LIKE");
        reservedIdentifiers.add("IN");
        reservedIdentifiers.add("IS");
        reservedIdentifiers.add("ESCAPE");
    }
}

