/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.impl.handler.session;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import org.jboss.aop.advice.Interceptor;
import org.jboss.ejb3.common.lang.SerializableMethod;
import org.jboss.ejb3.common.registrar.spi.Ejb3Registrar;
import org.jboss.ejb3.common.registrar.spi.Ejb3RegistrarLocator;
import org.jboss.ejb3.proxy.impl.handler.session.NotEligibleForDirectInvocationException;
import org.jboss.ejb3.proxy.impl.handler.session.SessionProxyInvocationHandler;
import org.jboss.ejb3.proxy.impl.remoting.ProxyRemotingUtils;
import org.jboss.ejb3.proxy.spi.container.InvokableContext;
import org.jboss.logging.Logger;

public abstract class SessionProxyInvocationHandlerBase
implements SessionProxyInvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(SessionProxyInvocationHandlerBase.class);
    private static final String METHOD_NAME_TO_STRING = "toString";
    private static final String METHOD_NAME_EQUALS = "equals";
    private static final String METHOD_NAME_HASH_CODE = "hashCode";
    private static final SerializableMethod METHOD_TO_STRING;
    private static final SerializableMethod METHOD_EQUALS;
    private static final SerializableMethod METHOD_HASH_CODE;
    private Object target;
    private Interceptor[] interceptors;
    private String containerName;
    private String containerGuid;
    private String businessInterfaceType;

    protected SessionProxyInvocationHandlerBase(String containerName, String containerGuid, Interceptor[] interceptors, String businessInterfaceType, Object target) {
        this.setContainerName(containerName);
        this.setContainerGuid(containerGuid);
        this.setInterceptors(interceptors);
        this.setBusinessInterfaceType(businessInterfaceType);
        this.setTarget(target);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String actualClass = this.getBusinessInterfaceType();
        SerializableMethod invokedMethod = new SerializableMethod(method, actualClass);
        return this.invoke(proxy, invokedMethod, args);
    }

    public Object invoke(Object proxy, SerializableMethod method, Object[] args) throws Throwable {
        try {
            return this.handleInvocationDirectly(proxy, args, method.toMethod());
        }
        catch (NotEligibleForDirectInvocationException nefdie) {
            log.debug((Object)("Couldn't handle invocation directly within " + this + ": " + nefdie.getMessage()));
            InvokableContext container = this.getContainer();
            if (args == null) {
                args = new Object[]{};
            }
            Object result = container.invoke(proxy, method, args);
            return result;
        }
    }

    protected Object handleInvocationDirectly(Object proxy, Object[] args, Method invokedMethod) throws NotEligibleForDirectInvocationException {
        assert (invokedMethod != null) : "Invoked Method was not set upon invocation of " + this.getClass().getName();
        if (invokedMethod.equals(METHOD_EQUALS.toMethod())) {
            assert (args.length == 1) : "Invocation for 'equals' should have exactly one argument, instead was: " + invokedMethod;
            Object argument = args[0];
            return this.invokeEquals(proxy, argument);
        }
        if (invokedMethod.equals(METHOD_TO_STRING.toMethod())) {
            assert (Proxy.isProxyClass(proxy.getClass())) : "Specified proxy invoked is not of type " + Proxy.class.getName();
            Class<?>[] implementedInterfaces = proxy.getClass().getInterfaces();
            HashSet interfacesSet = new HashSet();
            for (Class<?> interfaze : implementedInterfaces) {
                interfacesSet.add(interfaze);
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Proxy to ");
            sb.append(this.getContainerName());
            sb.append(" implementing ");
            sb.append(interfacesSet);
            return sb.toString();
        }
        if (invokedMethod.equals(METHOD_HASH_CODE.toMethod())) {
            return this.invokeHashCode(proxy);
        }
        throw new NotEligibleForDirectInvocationException("Current invocation \"" + invokedMethod + "\" is not eligible for direct handling by " + this);
    }

    protected boolean invokeEquals(Object proxy, Object argument) {
        Object argumentTarget;
        assert (Proxy.isProxyClass(proxy.getClass()) && Proxy.isProxyClass(argument.getClass())) : "invokeEquals handles only " + Proxy.class.getName();
        InvocationHandler proxyHandler = Proxy.getInvocationHandler(proxy);
        InvocationHandler argumentHandler = Proxy.getInvocationHandler(argument);
        if (!(argumentHandler instanceof SessionProxyInvocationHandler)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)(argument + " and " + this + " are not equal; handler of argument is not a " + SessionProxyInvocationHandler.class.getName()));
            }
            return false;
        }
        SessionProxyInvocationHandler proxySHandler = (SessionProxyInvocationHandler)proxyHandler;
        SessionProxyInvocationHandler argumentSHandler = (SessionProxyInvocationHandler)argumentHandler;
        String proxyContainerName = proxySHandler.getContainerName();
        assert (proxyContainerName != null) : "Container Name for " + proxySHandler + " was not set and is required";
        if (!proxyContainerName.equals(argumentSHandler.getContainerName())) {
            return false;
        }
        Object proxyTarget = proxySHandler.getTarget();
        if (proxyTarget != null && !proxyTarget.equals(argumentTarget = argumentSHandler.getTarget())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Not equal; different Session IDs - proxy== " + proxyTarget + ", argument==" + argumentTarget));
            }
            return false;
        }
        return true;
    }

    protected int invokeHashCode(Object proxy) {
        assert (Proxy.isProxyClass(proxy.getClass())) : "Unexpected proxy implementation";
        InvocationHandler handler = Proxy.getInvocationHandler(proxy);
        assert (handler instanceof SessionProxyInvocationHandler);
        SessionProxyInvocationHandler sHandler = (SessionProxyInvocationHandler)handler;
        int hash = 0;
        StringBuffer sb = new StringBuffer();
        sb.append(sHandler.getContainerName());
        sb.append(sHandler.getContainerGuid());
        String compositionString = sb.toString();
        hash = compositionString.hashCode();
        Object target = sHandler.getTarget();
        if (target != null) {
            hash += target.hashCode();
        }
        return hash;
    }

    protected InvokableContext getContainerLocally() {
        Object obj = Ejb3RegistrarLocator.locateRegistrar().lookup((Object)this.getContainerName());
        assert (obj instanceof InvokableContext) : "Container retrieved from " + Ejb3Registrar.class.getSimpleName() + " was not of expected type " + InvokableContext.class.getName() + " but was instead " + obj;
        return (InvokableContext)obj;
    }

    protected InvokableContext createRemoteProxyToContainer(String url) {
        InvokableContext container = ProxyRemotingUtils.createRemoteProxyToContainer(this.getContainerName(), this.getContainerGuid(), url, this.getInterceptors(), this.getTarget());
        return container;
    }

    protected abstract InvokableContext getContainer();

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        assert (containerName != null && containerName.trim().length() > 0) : "Container Name must be specified";
        this.containerName = containerName;
    }

    public Interceptor[] getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(Interceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    public String getContainerGuid() {
        return this.containerGuid;
    }

    public void setContainerGuid(String containerGuid) {
        this.containerGuid = containerGuid;
    }

    public String getBusinessInterfaceType() {
        return this.businessInterfaceType;
    }

    public void setBusinessInterfaceType(String businessInterfaceType) {
        this.businessInterfaceType = businessInterfaceType;
    }

    static {
        try {
            METHOD_TO_STRING = new SerializableMethod(Object.class.getDeclaredMethod(METHOD_NAME_TO_STRING, new Class[0]), Object.class);
            METHOD_EQUALS = new SerializableMethod(Object.class.getDeclaredMethod(METHOD_NAME_EQUALS, Object.class), Object.class);
            METHOD_HASH_CODE = new SerializableMethod(Object.class.getDeclaredMethod(METHOD_NAME_HASH_CODE, new Class[0]), Object.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException("Methods for handling directly by the InvocationHandler were not initialized correctly", nsme);
        }
    }
}

