/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.net.InetAddress;
import java.rmi.dgc.VMID;
import java.rmi.server.UID;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Executor;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.bootstrap.spi.util.ServerConfigUtil;
import org.jboss.ha.framework.server.JChannelFactoryMBean;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBean;
import org.jboss.util.loading.ContextClassLoaderSwitcher;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.ChannelListener;
import org.jgroups.ChannelListenerAdapter;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolData;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.TP;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.LazyThreadFactory;
import org.jgroups.util.ThreadDecorator;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.ThreadManager;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JChannelFactory
extends org.jgroups.JChannelFactory
implements JChannelFactoryMBean,
MBeanRegistration {
    protected static final Logger log = Logger.getLogger(JChannelFactory.class);
    public static final String UNSHARED_TRANSPORT_NAME_BASE = "unnamed_";
    private static final int CREATED = 6;
    private static final int STARTING = 2;
    private static final int STARTED = 3;
    private static final int STOPPING = 1;
    private static final int STOPPED = 0;
    private static final int DESTROYED = 5;
    private static final int FAILED = 4;
    private InetAddress nodeAddress;
    private String nodeName;
    private int namingServicePort = -1;
    private int state = 7;
    private boolean assignLogicalAddresses = true;
    private boolean manageNewThreadClassLoader = true;
    private boolean manageReleasedThreadClassLoader = false;
    private boolean addMissingSingletonName = true;
    private boolean domainSet;
    private final ContextClassLoaderSwitcher classLoaderSwitcher;
    private final Set<String> registeredChannels = new HashSet<String>();

    public JChannelFactory() {
        this.classLoaderSwitcher = (ContextClassLoaderSwitcher)AccessController.doPrivileged(ContextClassLoaderSwitcher.INSTANTIATOR);
    }

    public Channel createChannel() throws ChannelException {
        throw new ChannelException("No-arg createChannel() is not supported");
    }

    public Channel createChannel(Object properties) throws ChannelException {
        this.checkStarted();
        Channel channel = super.createChannel(properties);
        if (this.manageNewThreadClassLoader || this.manageReleasedThreadClassLoader) {
            this.fixChannelThreadManagement(channel);
        }
        if (this.assignLogicalAddresses) {
            this.setChannelUniqueId(channel);
        }
        return channel;
    }

    @Override
    public Channel createChannel(String stack_name) throws Exception {
        String props;
        this.checkStarted();
        String string = props = stack_name != null ? this.getConfig(stack_name) : null;
        if (props == null) {
            log.warn((Object)("No protocol stack found with name " + stack_name + "; creating default channel"));
            return this.createChannel();
        }
        JChannel channel = new JChannel(props);
        if (this.manageNewThreadClassLoader || this.manageReleasedThreadClassLoader) {
            this.fixChannelThreadManagement((Channel)channel);
        }
        if (this.assignLogicalAddresses) {
            this.setChannelUniqueId((Channel)channel);
        }
        return channel;
    }

    @Override
    public Channel createMultiplexerChannel(String stack_name, String id) throws Exception {
        this.checkStarted();
        String configStr = this.getConfig(stack_name);
        if (configStr == null) {
            throw new IllegalStateException("Unknown stack_name " + stack_name);
        }
        ProtocolStackConfigurator config = ConfiguratorFactory.getStackConfigurator((String)configStr);
        Map<String, String> tpProps = this.getTransportProperties(config);
        if (!tpProps.containsKey("singleton_name")) {
            if (this.addMissingSingletonName) {
                String singletonName = UNSHARED_TRANSPORT_NAME_BASE + stack_name;
                log.warn((Object)("Config for " + stack_name + " does not include " + "singleton_name; adding a name of " + singletonName + ". You should configure a singleton_name for this stack."));
                config = this.addSingletonName(config, singletonName);
                log.debug((Object)("Stack config after adding singleton_name is " + config.getProtocolStackString()));
                tpProps = this.getTransportProperties(config);
            } else {
                throw new IllegalStateException("Config for " + stack_name + " does not include " + "singleton_name and MuxChannels are not supported.");
            }
        }
        JChannel channel = new JChannel(config);
        if (this.manageNewThreadClassLoader || this.manageReleasedThreadClassLoader) {
            this.fixChannelThreadManagement((Channel)channel);
        }
        if (this.assignLogicalAddresses) {
            this.setChannelUniqueId((Channel)channel);
        }
        if (this.isExposeChannels() && id != null && id.length() > 0) {
            this.registerChannel(channel, id);
        }
        return channel;
    }

    @Override
    public Channel createMultiplexerChannel(String stack_name, String id, boolean register_for_state_transfer, String substate_id) throws Exception {
        return this.createMultiplexerChannel(stack_name, id);
    }

    @Override
    public void setDomain(String domain) {
        super.setDomain(domain);
        this.domainSet = true;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public InetAddress getNodeAddress() {
        return this.nodeAddress;
    }

    public void setNodeAddress(InetAddress nodeAddress) {
        this.nodeAddress = nodeAddress;
    }

    public int getNamingServicePort() {
        return this.namingServicePort;
    }

    public void setNamingServicePort(int jndiPort) {
        this.namingServicePort = jndiPort;
    }

    public boolean getAssignLogicalAddresses() {
        return this.assignLogicalAddresses;
    }

    public void setAssignLogicalAddresses(boolean logicalAddresses) {
        this.assignLogicalAddresses = logicalAddresses;
    }

    public boolean getManageNewThreadClassLoader() {
        return this.manageNewThreadClassLoader;
    }

    public void setManageNewThreadClassLoader(boolean manage) {
        this.manageNewThreadClassLoader = manage;
    }

    public boolean getManageReleasedThreadClassLoader() {
        return this.manageReleasedThreadClassLoader;
    }

    public void setManageReleasedThreadClassLoader(boolean manage) {
        this.manageReleasedThreadClassLoader = manage;
    }

    public boolean getAddMissingSingletonName() {
        return this.addMissingSingletonName;
    }

    public void setAddMissingSingletonName(boolean addMissingSingletonName) {
        this.addMissingSingletonName = addMissingSingletonName;
    }

    @Override
    public void create() throws Exception {
        if (this.state == 6 || this.state == 2 || this.state == 3 || this.state == 1 || this.state == 0) {
            log.debug((Object)("Ignoring create call; current state is " + this.getStateString()));
            return;
        }
        log.debug((Object)"Creating JChannelFactory");
        try {
            super.create();
            this.state = 6;
        }
        catch (Exception e) {
            log.debug((Object)"Initialization failed JChannelFactory", (Throwable)e);
            throw e;
        }
        log.debug((Object)"Created JChannelFactory");
    }

    @Override
    public void start() throws Exception {
        if (this.state == 2 || this.state == 3 || this.state == 1) {
            log.debug((Object)("Ignoring start call; current state is " + this.getStateString()));
            return;
        }
        if (this.state != 6 && this.state != 0 && this.state != 4) {
            log.debug((Object)"Start requested before create, calling create now");
            this.create();
        }
        this.state = 2;
        log.debug((Object)"Starting JChannelFactory");
        try {
            super.start();
        }
        catch (Exception e) {
            this.state = 4;
            log.debug((Object)"Starting failed JChannelFactory", (Throwable)e);
            throw e;
        }
        this.state = 3;
        log.debug((Object)"Started JChannelFactory");
    }

    @Override
    public void stop() {
        if (this.state != 3) {
            log.debug((Object)("Ignoring stop call; current state is " + this.getStateString()));
            return;
        }
        this.state = 1;
        log.debug((Object)"Stopping JChannelFactory");
        try {
            super.stop();
        }
        catch (Throwable e) {
            this.state = 4;
            log.warn((Object)"Stopping failed JChannelFactory", e);
            return;
        }
        this.state = 0;
        log.debug((Object)"Stopped JChannelFactory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (this.state == 5) {
            log.debug((Object)("Ignoring destroy call; current state is " + this.getStateString()));
            return;
        }
        if (this.state == 3) {
            log.debug((Object)"Destroy requested before stop, calling stop now");
            this.stop();
        }
        log.debug((Object)"Destroying JChannelFactory");
        try {
            HashSet<String> toUnregister = null;
            Set<String> set = this.registeredChannels;
            synchronized (set) {
                toUnregister = new HashSet<String>(this.registeredChannels);
            }
            for (String channelId : toUnregister) {
                this.unregister(channelId);
            }
        }
        catch (Throwable t) {
            log.warn((Object)"Destroying failed JChannelFactory", t);
        }
        this.state = 5;
        log.debug((Object)"Destroyed JChannelFactory");
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.setServer(server);
        if (!this.domainSet || this.getDomain() == null) {
            this.setDomain(name.getDomain());
        }
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (registrationDone != null && registrationDone.booleanValue() && this.state == 7) {
            this.state = 8;
        }
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        this.setServer(null);
        if (this.state == 5) {
            this.state = 7;
        }
    }

    protected ClassLoader getDefaultChannelThreadContextClassLoader() {
        return this.getClass().getClassLoader();
    }

    private void checkStarted() {
        if (this.state != 3) {
            throw new IllegalStateException("Cannot use factory; state is " + this.getStateString());
        }
    }

    private void setChannelUniqueId(Channel channel) {
        IpAddress address = (IpAddress)channel.getLocalAddress();
        if (address == null) {
            if (this.nodeName == null || "".equals(this.nodeName)) {
                this.nodeName = this.generateUniqueNodeName();
            }
            log.debug((Object)("Passing unique node id " + this.nodeName + " to the channel as additional data"));
            HashMap<String, byte[]> staticNodeName = new HashMap<String, byte[]>();
            staticNodeName.put("additional_data", this.nodeName.getBytes());
            channel.down(new Event(56, staticNodeName));
        } else if (address.getAdditionalData() == null) {
            if (channel.isConnected()) {
                throw new IllegalStateException("Underlying JChannel was connected before additional_data was set");
            }
        } else if (this.nodeName == null || "".equals(this.nodeName)) {
            this.nodeName = new String(address.getAdditionalData());
            log.warn((Object)("Field nodeName was not set but mux channel already had additional data -- setting nodeName to " + this.nodeName));
        }
    }

    private String getStateString() {
        return ServiceMBean.states[this.state];
    }

    private String generateUniqueNodeName() {
        String hostIP = null;
        InetAddress address = ServerConfigUtil.fixRemoteAddress((InetAddress)this.nodeAddress);
        if (address == null) {
            log.debug((Object)"unable to create a GUID for this cluster, check network configuration is correctly setup (getLocalHost has returned an exception)");
            log.debug((Object)"using a full GUID strategy");
            return new VMID().toString();
        }
        hostIP = address.getHostAddress();
        if (this.namingServicePort > 0) {
            return hostIP + ":" + this.namingServicePort;
        }
        log.warn((Object)"JNDI has been found but the service wasn't started. Most likely, HAPartition bean is missing dependency on JBoss Naming. Instead using host based UID strategy for defining a node GUID for the cluster.");
        String uid = new UID().toString();
        return hostIP + ":" + uid;
    }

    private Map<String, String> getTransportProperties(ProtocolStackConfigurator config) {
        HashMap<String, String> tpProps = null;
        try {
            ProtocolData[] protocols = config.getProtocolStack();
            ProtocolData transport = protocols[0];
            tpProps = transport.getParameters();
        }
        catch (UnsupportedOperationException uoe) {
            String configStr = config.getProtocolStackString();
            String tpConfigStr = configStr.substring(configStr.indexOf(40) + 1, configStr.indexOf(41));
            String[] params = tpConfigStr.split(";");
            tpProps = new HashMap<String, String>();
            for (String param : params) {
                String[] keyVal = param.split("=");
                if (keyVal.length != 2) {
                    throw new IllegalStateException("Invalid parameter " + param + " in stack " + configStr);
                }
                tpProps.put(keyVal[0], keyVal[1]);
            }
        }
        return tpProps;
    }

    private ProtocolStackConfigurator addSingletonName(ProtocolStackConfigurator orig, String singletonName) throws ChannelException {
        ProtocolStackConfigurator result = null;
        try {
            ProtocolData[] protocols = orig.getProtocolStack();
            ProtocolData transport = protocols[0];
            HashMap tpProps = transport.getParameters();
            tpProps.put("singleton_name", singletonName);
            result = orig;
        }
        catch (UnsupportedOperationException uoe) {
            String config = orig.getProtocolStackString();
            int idx = config.indexOf(40) + 1;
            StringBuilder builder = new StringBuilder(config.substring(0, idx));
            builder.append("singleton_name");
            builder.append('=');
            builder.append(singletonName);
            builder.append(';');
            builder.append(config.substring(idx));
            result = ConfiguratorFactory.getStackConfigurator((String)builder.toString());
        }
        return result;
    }

    private void fixChannelThreadManagement(Channel channel) throws ChannelException {
        if (!(channel instanceof JChannel)) {
            log.debug((Object)("Cannot fix thread pools for unknown Channel type " + channel.getClass().getName()));
            return;
        }
        JChannel jchannel = (JChannel)channel;
        ProtocolStack stack = jchannel.getProtocolStack();
        Vector protocols = stack.getProtocols();
        TP tp = null;
        for (int i = protocols.size() - 1; i >= 0; --i) {
            if (!(protocols.get(i) instanceof TP)) continue;
            tp = (TP)protocols.get(i);
            break;
        }
        ClassLoader defaultTCCL = this.getDefaultChannelThreadContextClassLoader();
        ThreadDecoratorImpl threadDecorator = new ThreadDecoratorImpl(defaultTCCL);
        if (this.manageNewThreadClassLoader) {
            this.fixProtocolThreadFactories(tp, threadDecorator);
        }
        if (this.manageReleasedThreadClassLoader) {
            this.fixTransportThreadPools(tp, threadDecorator);
        }
    }

    private void fixProtocolThreadFactories(TP tp, ThreadDecoratorImpl threadDecorator) {
        ThreadFactory stackFactory = tp.getThreadFactory();
        if (stackFactory == null) {
            stackFactory = new DefaultThreadFactory(Util.getGlobalThreadGroup(), "", false);
            tp.setThreadFactory(stackFactory);
        }
        this.fixThreadManager(stackFactory, threadDecorator, "TP.getThreadFactory()");
        log.debug((Object)("Fixed thread factory for " + tp));
        ThreadFactory timerFactory = tp.getTimerThreadFactory();
        if (timerFactory == null) {
            timerFactory = new LazyThreadFactory(Util.getGlobalThreadGroup(), "Timer", true, true);
            tp.setTimerThreadFactory(timerFactory);
        }
        this.fixThreadManager(timerFactory, threadDecorator, "TP.getTimerThreadFactory()");
        log.debug((Object)("Fixed timer thread factory for " + tp));
        ThreadGroup pool_thread_group = null;
        if (tp.isDefaulThreadPoolEnabled()) {
            ThreadFactory defaultPoolFactory = tp.getDefaultThreadPoolThreadFactory();
            if (defaultPoolFactory == null) {
                pool_thread_group = new ThreadGroup(Util.getGlobalThreadGroup(), "Thread Pools");
                defaultPoolFactory = new DefaultThreadFactory(pool_thread_group, "Incoming", false, true);
                tp.setThreadFactory(defaultPoolFactory);
            }
            this.fixThreadManager(defaultPoolFactory, threadDecorator, "TP.getDefaultThreadPoolThreadFactory()");
            log.debug((Object)("Fixed default pool thread factory for " + tp));
        }
        if (tp.isOOBThreadPoolEnabled()) {
            ThreadFactory oobPoolFactory = tp.getOOBThreadPoolThreadFactory();
            if (oobPoolFactory == null) {
                if (pool_thread_group == null) {
                    pool_thread_group = new ThreadGroup(Util.getGlobalThreadGroup(), "Thread Pools");
                }
                oobPoolFactory = new DefaultThreadFactory(pool_thread_group, "OOB", false, true);
                tp.setThreadFactory(oobPoolFactory);
            }
            this.fixThreadManager(oobPoolFactory, threadDecorator, "TP.getOOBThreadPoolThreadFactory()");
            log.debug((Object)("Fixed oob pool thread factory for " + tp));
        }
        HashMap<ThreadFactory, Protocol> factories = new HashMap<ThreadFactory, Protocol>();
        for (Protocol tmp = tp.getUpProtocol(); tmp != null; tmp = tmp.getUpProtocol()) {
            ThreadFactory f = tmp.getThreadFactory();
            if (f == null || factories.containsKey(f)) continue;
            factories.put(f, tmp);
        }
        for (Map.Entry entry : factories.entrySet()) {
            this.fixThreadManager(entry.getKey(), threadDecorator, ((Protocol)entry.getValue()).getClass().getSimpleName() + ".getThreadFactory()");
        }
        log.debug((Object)"Fixed Protocol thread factories");
    }

    private void fixTransportThreadPools(TP tp, ThreadDecoratorImpl threadDecorator) {
        Executor threadPool = tp.getDefaultThreadPool();
        if (tp.isDefaulThreadPoolEnabled()) {
            this.fixThreadManager(threadPool, threadDecorator, "TP.getDefaultThreadPool()");
            log.debug((Object)("Fixed default thread pool for " + tp));
        }
        threadPool = tp.getOOBThreadPool();
        if (tp.isOOBThreadPoolEnabled()) {
            this.fixThreadManager(threadPool, threadDecorator, "TP.getOOBThreadPool()");
            log.debug((Object)("Fixed OOB thread pool for " + tp));
        }
    }

    private void fixThreadManager(Object manager, ThreadDecoratorImpl decorator, String managerSource) {
        if (manager instanceof ThreadManager) {
            ThreadManager threadManager = (ThreadManager)manager;
            ThreadDecorator existing = threadManager.getThreadDecorator();
            if (existing instanceof ThreadDecoratorImpl) {
                return;
            }
            if (existing != null) {
                decorator.setParent(existing);
            }
            threadManager.setThreadDecorator((ThreadDecorator)decorator);
        } else {
            log.warn((Object)(managerSource + " is not a ThreadManager"));
        }
    }

    private void setDefaultThreadContextClassLoader(Thread thread, ClassLoader classLoader) {
        this.classLoaderSwitcher.setContextClassLoader(thread, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerChannel(JChannel ch, String channelId) throws Exception {
        if (this.getServer() != null) {
            JmxDeregistrationChannelListener listener = new JmxDeregistrationChannelListener(channelId);
            ch.addChannelListener((ChannelListener)listener);
            JmxConfigurator.registerChannel((JChannel)ch, (MBeanServer)this.getServer(), (String)this.getDomain(), (String)channelId, (boolean)this.isExposeProtocols());
            Set<String> set = this.registeredChannels;
            synchronized (set) {
                this.registeredChannels.add(channelId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(String channelId) {
        if (this.getServer() != null && this.registeredChannels.contains(channelId)) {
            String oname = this.getDomain() + ":type=channel,cluster=" + channelId;
            try {
                this.getServer().unregisterMBean(new ObjectName(oname));
                oname = this.getDomain() + ":type=protocol,cluster=" + channelId + ",*";
                JmxConfigurator.unregister((MBeanServer)this.getServer(), (String)oname);
                Set<String> set = this.registeredChannels;
                synchronized (set) {
                    this.registeredChannels.remove(channelId);
                }
            }
            catch (Exception e) {
                log.error((Object)("failed unregistering " + oname), (Throwable)e);
            }
        }
    }

    private class JmxDeregistrationChannelListener
    extends ChannelListenerAdapter {
        private final String channelId;

        JmxDeregistrationChannelListener(String channelId) {
            this.channelId = channelId;
        }

        public void channelClosed(Channel channel) {
            JChannelFactory.this.unregister(this.channelId);
        }
    }

    private class ThreadDecoratorImpl
    implements ThreadDecorator {
        private final ClassLoader classloader;
        private ThreadDecorator parent;

        private ThreadDecoratorImpl(ClassLoader classloader) {
            this.classloader = classloader;
        }

        public void threadCreated(Thread thread) {
            if (this.parent != null) {
                this.parent.threadCreated(thread);
            }
            JChannelFactory.this.setDefaultThreadContextClassLoader(thread, this.classloader);
        }

        public void threadReleased(Thread thread) {
            if (this.parent != null) {
                this.parent.threadCreated(thread);
            }
            JChannelFactory.this.setDefaultThreadContextClassLoader(thread, this.classloader);
        }

        public ThreadDecorator getParent() {
            return this.parent;
        }

        public void setParent(ThreadDecorator parent) {
            this.parent = parent;
        }
    }
}

