/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.UnsupportedOptionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigurable
implements Configurable {
    private final Map<ChannelOption<?>, Object> optionMap = new HashMap();
    private final Set<ChannelOption<?>> validOptions;

    protected AbstractConfigurable(Set<ChannelOption<?>> validOptions) {
        this.validOptions = validOptions;
    }

    public Set<ChannelOption<?>> getOptions() {
        return this.optionMap.keySet();
    }

    public <T> T getOption(ChannelOption<T> option) throws UnsupportedOptionException, IOException {
        if (this.validOptions.contains(option)) {
            return option.getType().cast(this.optionMap.get(option));
        }
        throw AbstractConfigurable.badOption(option);
    }

    public <T> AbstractConfigurable setOption(ChannelOption<T> option, T value) throws IllegalArgumentException, IOException {
        if (!this.validOptions.contains(option)) {
            throw AbstractConfigurable.badOption(option);
        }
        this.optionMap.put(option, option.getType().cast(value));
        return this;
    }

    private static UnsupportedOptionException badOption(ChannelOption<?> option) {
        return new UnsupportedOptionException("Option " + option + " is unsupported");
    }
}

