/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.util;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.rhq.core.domain.util.OrderingField;
import org.rhq.core.domain.util.PageOrdering;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageControl
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_ORDERING_FIELD_COUNT = 3;
    public static final int SIZE_UNLIMITED = -1;
    public static final int SIZE_MAX = 100;
    private int pageNumber = 0;
    private int pageSize = 100;
    private LinkedList<OrderingField> orderingFields = new LinkedList();

    public PageControl() {
    }

    public PageControl(int pageNumber, int pageSize) {
        this();
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
    }

    public PageControl(int pageNumber, int pageSize, OrderingField ... orderingFields) {
        this(pageNumber, pageSize);
        for (OrderingField orderingField : orderingFields) {
            if (orderingField.getField() == null) continue;
            this.orderingFields.add(orderingField);
        }
    }

    public static PageControl getUnlimitedInstance() {
        return new PageControl(0, -1);
    }

    public static PageControl getSingleRowInstance() {
        return new PageControl(0, 1);
    }

    public void initDefaultOrderingField(String defaultField) {
        this.initDefaultOrderingField(defaultField, PageOrdering.ASC);
    }

    public void addDefaultOrderingField(String defaultField) {
        this.addDefaultOrderingField(defaultField, PageOrdering.ASC);
    }

    public void initDefaultOrderingField(String defaultField, PageOrdering defaultPageOrdering) {
        if (this.orderingFields.size() > 0) {
            return;
        }
        this.addDefaultOrderingField(defaultField, defaultPageOrdering);
    }

    public void addDefaultOrderingField(String defaultField, PageOrdering defaultPageOrdering) {
        for (OrderingField ordering : this.orderingFields) {
            if (!ordering.getField().equals(defaultField)) continue;
            return;
        }
        this.orderingFields.add(new OrderingField(defaultField, defaultPageOrdering));
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public PageOrdering getPrimarySortOrder() {
        OrderingField primaryOrderingField = this.getPrimaryOrderingField();
        if (primaryOrderingField == null) {
            return null;
        }
        return this.getPrimaryOrderingField().getOrdering();
    }

    public void setPrimarySortOrder(PageOrdering sortOrder) {
        OrderingField primaryOrderingField = this.getPrimaryOrderingField();
        if (primaryOrderingField == null) {
            return;
        }
        primaryOrderingField.setOrdering(sortOrder);
    }

    public String getPrimarySortColumn() {
        OrderingField primaryOrderingField = this.getPrimaryOrderingField();
        if (primaryOrderingField == null) {
            return null;
        }
        return primaryOrderingField.getField();
    }

    public void setPrimarySort(String sortColumn, PageOrdering sortOrder) {
        OrderingField primaryOrderingField = this.getPrimaryOrderingField();
        if (primaryOrderingField == null) {
            primaryOrderingField = new OrderingField(sortColumn, sortOrder);
            this.orderingFields.add(primaryOrderingField);
        } else {
            primaryOrderingField.setField(sortColumn);
            primaryOrderingField.setOrdering(sortOrder);
        }
    }

    private OrderingField getPrimaryOrderingField() {
        OrderingField result = null;
        if (this.orderingFields.size() != 0) {
            result = this.orderingFields.get(0);
        }
        return result;
    }

    public OrderingField[] getOrderingFieldsAsArray() {
        return this.orderingFields.toArray(new OrderingField[0]);
    }

    public List<OrderingField> getOrderingFields() {
        return this.orderingFields;
    }

    public void truncateOrderingFields(int keepFieldCount) {
        int removeCount = this.orderingFields.size() - keepFieldCount;
        for (int i = 0; i < removeCount; ++i) {
            this.orderingFields.removeLast();
        }
    }

    public void sortBy(String sortField) {
        boolean wasAlreadySortedOn = false;
        int sz = this.orderingFields.size();
        for (int i = 0; i < sz; ++i) {
            OrderingField field = this.orderingFields.get(i);
            if (!sortField.equals(field.getField())) continue;
            this.orderingFields.remove(i);
            field.flipOrdering();
            this.orderingFields.addFirst(field);
            wasAlreadySortedOn = true;
            break;
        }
        if (!wasAlreadySortedOn) {
            OrderingField field = new OrderingField(sortField, PageOrdering.ASC);
            this.orderingFields.addFirst(field);
            if (this.orderingFields.size() > 3) {
                this.orderingFields.removeLast();
            }
        }
    }

    public int getStartRow() {
        return this.pageNumber * this.pageSize;
    }

    public void reset() {
        this.setPageNumber(0);
        this.setPageSize(15);
        this.orderingFields = new LinkedList();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("PageControl[");
        buf.append("page=").append(this.pageNumber).append(", ");
        buf.append("size=").append(this.pageSize);
        int i = 0;
        if (this.orderingFields.size() > 0) {
            buf.append(", sort[");
            for (OrderingField orderingField : this.orderingFields) {
                if (i++ != 0) {
                    buf.append(", ");
                }
                buf.append(orderingField.getField()).append(" ").append((Object)orderingField.getOrdering());
            }
            buf.append("]");
        }
        buf.append("]");
        return buf.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return new PageControl(this.pageNumber, this.pageSize, this.getOrderingFieldsAsArray());
    }
}

