/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.util.PageControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
public class PageList<E>
extends ArrayList<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(PageList.class);
    private int totalSize = 0;
    private boolean isUnbounded;
    private PageControl pageControl;

    public PageList() {
    }

    public PageList(PageControl pageControl) {
        this.isUnbounded = true;
        this.pageControl = pageControl;
    }

    public PageList(Collection<? extends E> collection, PageControl pageControl) {
        super(collection);
        this.isUnbounded = true;
        this.pageControl = pageControl;
    }

    public PageList(Collection<? extends E> collection, int totalSize, PageControl pageControl) {
        super(collection);
        this.totalSize = totalSize;
        if (collection.size() == 0 && totalSize > 0) {
            LOG.warn((Object)("PageList was passed an empty collection but 'totalSize' was " + totalSize + ", " + pageControl));
        }
        this.isUnbounded = false;
        this.pageControl = pageControl;
    }

    public PageControl getPageControl() {
        return this.pageControl;
    }

    public void setPageControl(PageControl pageControl) {
        this.pageControl = pageControl;
    }

    public ArrayList<E> getValues() {
        return this;
    }

    public void setValues(ArrayList<E> values) {
        this.clear();
        this.addAll(values);
    }

    public int getTotalSize() {
        return Math.max(this.size(), this.totalSize);
    }

    public void setTotalSize(int totalSize) {
        this.isUnbounded = false;
        this.totalSize = totalSize;
    }

    public boolean isUnbounded() {
        return this.isUnbounded;
    }

    public void setUnbounded(boolean isUnbounded) {
        this.isUnbounded = isUnbounded;
    }

    @Override
    public String toString() {
        return "PageList" + super.toString();
    }
}

