/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.pointcut.CFlowMatcher;
import org.jboss.aop.pointcut.ast.ASTCFlowExpression;

class SortedCFlowInterceptor
implements Interceptor {
    private Interceptor[] sortedInterceptors;
    private CachedCFlow[] sortedCFlows;
    private CachedCFlow[] cflows;
    private Map<Integer, Interceptor[]> chains;

    public SortedCFlowInterceptor(Interceptor[] sortedInterceptors, ASTCFlowExpression[] sortedCFlows) {
        this.sortedInterceptors = sortedInterceptors;
        this.sortedCFlows = new CachedCFlow[sortedCFlows.length];
        HashSet<CachedCFlow> cflowSet = new HashSet<CachedCFlow>();
        for (int i = 0; i < sortedCFlows.length; ++i) {
            if (sortedCFlows[i] == null) continue;
            this.sortedCFlows[i] = new CachedCFlow(sortedCFlows[i]);
            cflowSet.add(this.sortedCFlows[i]);
        }
        this.chains = new LinkedHashMap<Integer, Interceptor[]>(2, 1.0f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Integer, Interceptor[]> eldest) {
                return this.size() > 5;
            }
        };
        this.cflows = cflowSet.toArray(new CachedCFlow[cflowSet.size()]);
    }

    public String getName() {
        return "SortedCFlowInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Interceptor[] chain;
        int key = 0;
        for (int i = 0; i < this.cflows.length; ++i) {
            key = key + this.cflows[i].evaluate(invocation) << i;
        }
        if (this.chains.containsKey(key)) {
            chain = this.chains.get(key);
        } else {
            ArrayList<Interceptor> chainCollection = new ArrayList<Interceptor>();
            for (int i = 0; i < this.sortedInterceptors.length; ++i) {
                if (this.sortedCFlows[i] != null && !this.sortedCFlows[i].matches()) continue;
                chainCollection.add(this.sortedInterceptors[i]);
            }
            chain = chainCollection.toArray(new Interceptor[chainCollection.size()]);
            this.chains.put(key, chain);
        }
        return invocation.getWrapper(chain).invokeNext();
    }

    private static class CachedCFlow {
        private ASTCFlowExpression cflow;
        private boolean matches;

        public CachedCFlow(ASTCFlowExpression cflow) {
            this.cflow = cflow;
            this.matches = false;
        }

        public byte evaluate(Invocation invocation) {
            this.matches = new CFlowMatcher().matches(this.cflow, invocation);
            return this.matches ? (byte)1 : 0;
        }

        public boolean matches() {
            return this.matches;
        }
    }
}

