/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.tx;

import javax.ejb.EJBException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.tx.BMTInterceptor;
import org.jboss.logging.Logger;

public class StatelessBMTInterceptor
extends BMTInterceptor {
    private static final Logger log = Logger.getLogger(StatelessBMTInterceptor.class);

    public StatelessBMTInterceptor(TransactionManager tm) {
        super(tm);
    }

    private void checkStatelessDone(String ejbName, Exception ex) {
        int status = 6;
        try {
            status = this.tm.getStatus();
        }
        catch (SystemException sex) {
            log.error((Object)"Failed to get status", (Throwable)sex);
        }
        switch (status) {
            case 0: 
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                try {
                    this.tm.rollback();
                }
                catch (Exception sex) {
                    log.error((Object)"Failed to rollback", (Throwable)sex);
                }
            }
            case 2: {
                String msg = "Application error: BMT stateless bean " + ejbName + " should complete transactions before" + " returning (ejb1.1 spec, 11.6.1)";
                log.error((Object)msg);
                if (ex != null) {
                    if (ex instanceof EJBException) {
                        throw (EJBException)ex;
                    }
                    throw new EJBException(msg, ex);
                }
                throw new EJBException(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleInvocation(Invocation invocation) throws Throwable {
        assert (this.tm.getTransaction() == null) : "can't handle BMT transaction, there is a transaction active";
        String ejbName = invocation.getAdvisor().getName();
        boolean exceptionThrown = false;
        try {
            Object object = invocation.invokeNext();
            return object;
        }
        catch (Exception ex) {
            exceptionThrown = true;
            this.checkStatelessDone(ejbName, ex);
            throw ex;
        }
        finally {
            try {
                if (!exceptionThrown) {
                    this.checkStatelessDone(ejbName, null);
                }
            }
            finally {
                this.tm.suspend();
            }
        }
    }
}

