/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.util.ArrayList;
import java.util.Set;
import org.jboss.remoting.transport.socket.ServerThread;
import org.jboss.util.LRUCachePolicy;

public class LRUPool
extends LRUCachePolicy {
    private Object needEvictionLock = new Object();
    private boolean needEviction;

    public LRUPool(int min, int max) {
        super(min, max);
    }

    protected void entryRemoved(LRUCachePolicy.LRUCacheEntry entry) {
        ServerThread thread = (ServerThread)entry.m_object;
        thread.evict();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict() {
        LRUCachePolicy.LRUCacheEntry entry = this.m_list.m_tail;
        while (entry != null) {
            ServerThread thread = (ServerThread)entry.m_object;
            if (thread.evict()) {
                return;
            }
            entry = entry.m_prev;
        }
        Object object = this.needEvictionLock;
        synchronized (object) {
            this.needEviction = true;
        }
    }

    public Set getContents() {
        return this.m_map.keySet();
    }

    public ArrayList getContentsByAscendingAge() {
        ArrayList<Object> list = new ArrayList<Object>(this.size());
        LRUCachePolicy.LRUCacheEntry entry = this.m_list.m_head;
        while (entry != null) {
            list.add(entry.m_object);
            entry = entry.m_next;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getEvictionNeeded() {
        Object object = this.needEvictionLock;
        synchronized (object) {
            boolean answer = this.needEviction;
            this.needEviction = false;
            return answer;
        }
    }
}

