/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.metadata.XmlLoadable;
import org.jboss.util.StringPropertyReplacer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class MetaData
implements Cloneable,
XmlLoadable {
    protected static Logger log = Logger.getLogger(MetaData.class);
    public static final byte TX_NOT_SUPPORTED = 0;
    public static final byte TX_REQUIRED = 1;
    public static final byte TX_SUPPORTS = 2;
    public static final byte TX_REQUIRES_NEW = 3;
    public static final byte TX_MANDATORY = 4;
    public static final byte TX_NEVER = 5;
    public static final byte TX_UNKNOWN = 6;

    public static Iterator getChildrenByTagName(Element element, String tagName) {
        if (element == null) {
            return null;
        }
        NodeList children = element.getChildNodes();
        ArrayList<Node> goodChildren = new ArrayList<Node>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node currentChild = children.item(i);
            if (currentChild.getNodeType() != 1 || !((Element)currentChild).getTagName().equals(tagName)) continue;
            goodChildren.add(currentChild);
        }
        return goodChildren.iterator();
    }

    public static Element getUniqueChild(Element element, String tagName) {
        Iterator goodChildren = MetaData.getChildrenByTagName(element, tagName);
        if (goodChildren != null && goodChildren.hasNext()) {
            Element child = (Element)goodChildren.next();
            if (goodChildren.hasNext()) {
                throw new IllegalStateException("expected only one " + tagName + " tag");
            }
            return child;
        }
        throw new IllegalStateException("expected one " + tagName + " tag");
    }

    public static Element getOptionalChild(Element element, String tagName) {
        return MetaData.getOptionalChild(element, tagName, null);
    }

    public static Element getOptionalChild(Element element, String tagName, Element defaultElement) {
        Iterator goodChildren = MetaData.getChildrenByTagName(element, tagName);
        if (goodChildren != null && goodChildren.hasNext()) {
            Element child = (Element)goodChildren.next();
            if (goodChildren.hasNext()) {
                throw new IllegalStateException("expected only one " + tagName + " tag");
            }
            return child;
        }
        return defaultElement;
    }

    public static String getElementAttribute(Element element, String attrName) {
        return MetaData.getElementAttribute(element, attrName, true);
    }

    public static String getElementAttribute(Element element, String attrName, boolean replace) {
        if (element == null) {
            return null;
        }
        if (attrName == null || !element.hasAttribute(attrName)) {
            return null;
        }
        String result = element.getAttribute(attrName);
        if (replace) {
            return StringPropertyReplacer.replaceProperties((String)result.trim());
        }
        return result.trim();
    }

    public static String getElementContent(Element element) {
        return MetaData.getElementContent(element, null);
    }

    public static String getElementContent(Element element, String defaultStr) {
        return MetaData.getElementContent(element, defaultStr, true);
    }

    public static String getElementContent(Element element, String defaultStr, boolean replace) {
        if (element == null) {
            return defaultStr;
        }
        NodeList children = element.getChildNodes();
        String result = "";
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() == 3 || children.item(i).getNodeType() == 4) {
                result = result + children.item(i).getNodeValue();
                continue;
            }
            if (children.item(i).getNodeType() == 8) continue;
            result = result + children.item(i).getFirstChild();
        }
        if (replace) {
            return StringPropertyReplacer.replaceProperties((String)result.trim());
        }
        return result.trim();
    }

    public static String getFirstElementContent(Element element, String defaultStr) {
        return MetaData.getFirstElementContent(element, defaultStr, true);
    }

    public static String getFirstElementContent(Element element, String defaultStr, boolean replace) {
        if (element == null) {
            return defaultStr;
        }
        NodeList children = element.getChildNodes();
        String result = "";
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() == 3 || children.item(i).getNodeType() == 4) {
                String val = children.item(i).getNodeValue();
                result = result + val;
                continue;
            }
            if (children.item(i).getNodeType() != 8) continue;
        }
        if (replace) {
            return StringPropertyReplacer.replaceProperties((String)result.trim());
        }
        return result.trim();
    }

    public static String getUniqueChildContent(Element element, String tagName) {
        return MetaData.getElementContent(MetaData.getUniqueChild(element, tagName));
    }

    public static String getOptionalChildContent(Element element, String tagName) {
        return MetaData.getElementContent(MetaData.getOptionalChild(element, tagName));
    }

    public static String getOptionalChildContent(Element element, String tagName, String defaultValue) {
        return MetaData.getElementContent(MetaData.getOptionalChild(element, tagName), defaultValue);
    }

    public static boolean getOptionalChildBooleanContent(Element element, String name) {
        Element child = MetaData.getOptionalChild(element, name);
        if (child != null) {
            String value = MetaData.getElementContent(child).toLowerCase();
            return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
        }
        return false;
    }

    public static boolean getOptionalChildBooleanContent(Element element, String name, boolean defaultValue) {
        Element child = MetaData.getOptionalChild(element, name);
        boolean flag = defaultValue;
        if (child != null) {
            String value = MetaData.getElementContent(child).toLowerCase();
            flag = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
        }
        return flag;
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public void importXml(Element element) throws Exception {
        String rootTag = element.getOwnerDocument().getDocumentElement().getTagName();
        if (rootTag.equals("jboss")) {
            this.importJbossXml(element);
        } else if (rootTag.equals("ejb-jar")) {
            this.importEjbJarXml(element);
        } else {
            throw new IllegalStateException("Unrecognized root tag : " + rootTag);
        }
    }

    public void importEjbJarXml(Element element) throws Exception {
    }

    public void importJbossXml(Element element) throws Exception {
    }

    protected boolean jdk13Enabled() {
        String javaVersion = System.getProperty("java.vm.version");
        return javaVersion.compareTo("1.3") >= 0;
    }
}

