/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mail;

import java.util.List;
import org.buni.meldware.mail.management.AdminTool;
import org.buni.meldware.mail.util.MMJMXUtil;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.jboss.seam.mail.MeldwareUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.mail.meldware")
@Startup
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@Install(precedence=0, classDependencies={"org.buni.meldware.mail.mailbox.Mailbox"}, value=false)
public class Meldware {
    private List<MeldwareUser> users;
    private List<String> domains;
    private Log log = Logging.getLog(Meldware.class);

    @Create
    public void create() {
        this.log.info((Object)"Creating users and mailboxes", new Object[0]);
        AdminTool at = (AdminTool)MMJMXUtil.getMBean((String)"meldware.mail:type=MailServices,name=AdminTool", AdminTool.class);
        for (MeldwareUser meldwareUser : this.getUsers()) {
            at.createUser(meldwareUser.getUsername(), meldwareUser.getPassword(), meldwareUser.getRoles());
            this.log.info((Object)"Created #0 #1 #2", meldwareUser.isAdministrator() ? "administrator" : "user", meldwareUser.getUsername(), meldwareUser.getAliases() == null || meldwareUser.getAliases().size() == 0 ? "" : "with aliases " + meldwareUser.getAliases());
        }
    }

    public List<MeldwareUser> getUsers() {
        return this.users;
    }

    public void setUsers(List<MeldwareUser> users) {
        this.users = users;
    }

    public List<String> getDomains() {
        return this.domains;
    }

    public void setDomains(List<String> domains) {
        this.domains = domains;
    }
}

