/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.jcr.RepositoryException;
import javax.transaction.TransactionManager;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.WorkspaceStorageCache;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.FilePersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.TxIsolatedOperation;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache.JBossCacheWorkspaceStorageCache;
import org.exoplatform.services.jcr.impl.storage.SystemDataContainerHolder;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;
import org.exoplatform.services.transaction.TransactionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheableWorkspaceDataManager
extends WorkspacePersistentDataManager {
    protected final WorkspaceStorageCache cache;
    protected final Map<Integer, DataRequest> requestCache;
    private TransactionManager transactionManager;

    public CacheableWorkspaceDataManager(WorkspaceDataContainer dataContainer, WorkspaceStorageCache cache, SystemDataContainerHolder systemDataContainerHolder, TransactionService transactionService) {
        super(dataContainer, systemDataContainerHolder);
        this.cache = cache;
        this.requestCache = new HashMap<Integer, DataRequest>();
        this.addItemPersistenceListener(cache);
        this.transactionManager = transactionService.getTransactionManager();
    }

    public CacheableWorkspaceDataManager(WorkspaceDataContainer dataContainer, WorkspaceStorageCache cache, SystemDataContainerHolder systemDataContainerHolder) {
        super(dataContainer, systemDataContainerHolder);
        this.cache = cache;
        this.requestCache = new HashMap<Integer, DataRequest>();
        this.addItemPersistenceListener(cache);
        this.transactionManager = cache instanceof JBossCacheWorkspaceStorageCache ? ((JBossCacheWorkspaceStorageCache)cache).getTransactionManager() : null;
    }

    public WorkspaceStorageCache getCache() {
        return this.cache;
    }

    @Override
    public int getChildNodesCount(NodeData parent) throws RepositoryException {
        List<NodeData> childNodes;
        if (this.cache.isEnabled() && (childNodes = this.cache.getChildNodes(parent)) != null) {
            return childNodes.size();
        }
        return super.getChildNodesCount(parent);
    }

    @Override
    public List<NodeData> getChildNodesData(NodeData nodeData) throws RepositoryException {
        return this.getChildNodesData(nodeData, false);
    }

    @Override
    public List<PropertyData> getChildPropertiesData(NodeData nodeData) throws RepositoryException {
        List<PropertyData> childs = this.getChildPropertiesData(nodeData, false);
        for (PropertyData prop : childs) {
            this.fixPropertyValues(prop);
        }
        return childs;
    }

    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name) throws RepositoryException {
        ItemData data = this.getCachedItemData(parentData, name);
        if (data == null) {
            data = this.getPersistedItemData(parentData, name);
        } else if (!data.isNode()) {
            this.fixPropertyValues((PropertyData)data);
        }
        return data;
    }

    @Override
    public ItemData getItemData(String identifier) throws RepositoryException {
        ItemData data = this.getCachedItemData(identifier);
        if (data == null) {
            return this.getPersistedItemData(identifier);
        }
        if (!data.isNode()) {
            this.fixPropertyValues((PropertyData)data);
        }
        return data;
    }

    @Override
    public List<PropertyData> getReferencesData(String identifier, boolean skipVersionStorage) throws RepositoryException {
        return super.getReferencesData(identifier, skipVersionStorage);
    }

    @Override
    public List<PropertyData> listChildPropertiesData(NodeData nodeData) throws RepositoryException {
        return this.listChildPropertiesData(nodeData, false);
    }

    @Override
    public void save(ItemStateChangesLog changesLog) throws RepositoryException {
        if (this.isTxAware()) {
            new SaveInTransaction(changesLog).perform();
        } else {
            super.save(changesLog);
            this.notifySaveItems(changesLog, false);
        }
    }

    protected ItemData getCachedItemData(NodeData parentData, QPathEntry name) throws RepositoryException {
        return this.cache.get(parentData.getIdentifier(), name);
    }

    protected ItemData getCachedItemData(String identifier) throws RepositoryException {
        return this.cache.get(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<NodeData> getChildNodesData(NodeData nodeData, boolean forcePersistentRead) throws RepositoryException {
        DataRequest request = new DataRequest(nodeData.getIdentifier(), 1);
        List<NodeData> childNodes = null;
        if (!forcePersistentRead && this.cache.isEnabled()) {
            request.waitSame();
            childNodes = this.cache.getChildNodes(nodeData);
            if (childNodes != null) {
                return childNodes;
            }
        }
        try {
            request.start();
            childNodes = super.getChildNodesData(nodeData);
            if (this.cache.isEnabled()) {
                NodeData parentData = (NodeData)this.cache.get(nodeData.getIdentifier());
                if (parentData == null) {
                    parentData = (NodeData)super.getItemData(nodeData.getIdentifier());
                }
                if (parentData != null) {
                    this.cache.addChildNodes(parentData, childNodes);
                }
            }
            List<NodeData> list = childNodes;
            Object var7_6 = null;
            request.done();
            return list;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            request.done();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PropertyData> getChildPropertiesData(NodeData nodeData, boolean forcePersistentRead) throws RepositoryException {
        DataRequest request = new DataRequest(nodeData.getIdentifier(), 2);
        List<PropertyData> childProperties = null;
        if (!forcePersistentRead && this.cache.isEnabled()) {
            request.waitSame();
            childProperties = this.cache.getChildProperties(nodeData);
            if (childProperties != null) {
                return childProperties;
            }
        }
        try {
            request.start();
            childProperties = super.getChildPropertiesData(nodeData);
            if (childProperties.size() > 0 && this.cache.isEnabled()) {
                NodeData parentData = (NodeData)this.cache.get(nodeData.getIdentifier());
                if (parentData == null) {
                    parentData = (NodeData)super.getItemData(nodeData.getIdentifier());
                }
                if (parentData != null) {
                    this.cache.addChildProperties(parentData, childProperties);
                }
            }
            List<PropertyData> list = childProperties;
            Object var7_6 = null;
            request.done();
            return list;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            request.done();
            throw throwable;
        }
    }

    protected ItemData getPersistedItemData(NodeData parentData, QPathEntry name) throws RepositoryException {
        ItemData data = super.getItemData(parentData, name);
        if (data != null && this.cache.isEnabled()) {
            this.cache.put(data);
        }
        return data;
    }

    protected ItemData getPersistedItemData(String identifier) throws RepositoryException {
        ItemData data = super.getItemData(identifier);
        if (data != null && this.cache.isEnabled()) {
            this.cache.put(data);
        }
        return data;
    }

    protected List<PropertyData> listChildPropertiesData(NodeData nodeData, boolean forcePersistentRead) throws RepositoryException {
        List<PropertyData> propertiesList;
        DataRequest request = new DataRequest(nodeData.getIdentifier(), 2);
        if (!forcePersistentRead && this.cache.isEnabled()) {
            request.waitSame();
            propertiesList = this.cache.listChildProperties(nodeData);
            if (propertiesList != null) {
                return propertiesList;
            }
        }
        if ((propertiesList = super.listChildPropertiesData(nodeData)).size() > 0 && this.cache.isEnabled()) {
            NodeData parentData = (NodeData)this.cache.get(nodeData.getIdentifier());
            if (parentData == null) {
                parentData = (NodeData)super.getItemData(nodeData.getIdentifier());
            }
            if (parentData != null) {
                this.cache.addChildPropertiesList(parentData, propertiesList);
            }
        }
        return propertiesList;
    }

    protected boolean isTxAware() {
        return this.transactionManager != null;
    }

    protected void fixPropertyValues(PropertyData prop) throws RepositoryException {
        List<ValueData> vals = prop.getValues();
        for (int i = 0; i < vals.size(); ++i) {
            FilePersistedValueData fpvd;
            ValueData vd = vals.get(i);
            if (vd.isByteArray() || (fpvd = (FilePersistedValueData)vd).getFile() != null) continue;
            ValueData svd = this.getPropertyValue(prop.getIdentifier(), vd.getOrderNumber(), prop.getPersistedVersion());
            if (svd == null) {
                throw new RepositoryException("Value cannot be found in storage for cached Property " + prop.getQPath().getAsString() + ", orderNumb:" + vd.getOrderNumber() + ", pversion:" + prop.getPersistedVersion());
            }
            vals.set(i, svd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueData getPropertyValue(String propertyId, int orderNumb, int persistedVersion) throws IllegalStateException, RepositoryException {
        ValueData valueData;
        JDBCStorageConnection conn = (JDBCStorageConnection)this.dataContainer.openConnection();
        try {
            valueData = conn.getValue(propertyId, orderNumb, persistedVersion);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            conn.close();
            throw throwable;
        }
        conn.close();
        return valueData;
    }

    protected class SaveInTransaction
    extends TxIsolatedOperation {
        final ItemStateChangesLog changes;

        SaveInTransaction(ItemStateChangesLog changes) {
            super(CacheableWorkspaceDataManager.this.transactionManager);
            this.changes = changes;
        }

        protected void action() throws RepositoryException {
            CacheableWorkspaceDataManager.super.save(this.changes);
        }

        protected void txAction() throws RepositoryException {
            super.txAction();
            try {
                CacheableWorkspaceDataManager.this.notifySaveItems(this.changes, false);
            }
            catch (Throwable th) {
                throw new RepositoryException(th);
            }
        }
    }

    protected class DataRequest {
        public static final int GET_NODES = 1;
        public static final int GET_PROPERTIES = 2;
        private static final int GET_ITEM_ID = 3;
        private static final int GET_ITEM_NAME = 4;
        protected final int type;
        protected final String parentId;
        protected final String id;
        protected final QPathEntry name;
        protected final int hcode;
        protected CountDownLatch ready = new CountDownLatch(1);

        DataRequest(String parentId, int type) {
            this.parentId = parentId;
            this.name = null;
            this.id = null;
            this.type = type;
            this.hcode = 31 * (31 + this.type) + this.parentId.hashCode();
        }

        DataRequest(String parentId, QPathEntry name) {
            this.parentId = parentId;
            this.name = name;
            this.id = null;
            this.type = 4;
            int hc = 31 * (31 + this.type) + this.parentId.hashCode();
            this.hcode = 31 * hc + this.name.hashCode();
        }

        DataRequest(String id) {
            this.parentId = null;
            this.name = null;
            this.id = id;
            this.type = 3;
            this.hcode = 31 * (31 + this.type) + this.id.hashCode();
        }

        DataRequest waitSame() {
            DataRequest prev = CacheableWorkspaceDataManager.this.requestCache.get(this.hashCode());
            if (prev != null) {
                prev.await();
            }
            return this;
        }

        void start() {
            CacheableWorkspaceDataManager.this.requestCache.put(this.hashCode(), this);
        }

        void done() {
            this.ready.countDown();
            CacheableWorkspaceDataManager.this.requestCache.remove(this.hashCode());
        }

        void await() {
            try {
                this.ready.await();
            }
            catch (InterruptedException e) {
                WorkspacePersistentDataManager.LOG.warn((Object)("Can't wait for same request process. " + e), (Throwable)e);
            }
        }

        public boolean equals(Object obj) {
            return this.hcode == obj.hashCode();
        }

        public int hashCode() {
            return this.hcode;
        }
    }
}

