/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;

public class DialectDetecter {
    public static String detect(DatabaseMetaData metaData) throws SQLException {
        String databaseName = metaData.getDatabaseProductName();
        if ("HSQL Database Engine".equals(databaseName)) {
            return DBConstants.DB_DIALECT_HSQLDB;
        }
        if ("H2".equals(databaseName)) {
            return DBConstants.DB_DIALECT_H2;
        }
        if ("MySQL".equals(databaseName)) {
            return DBConstants.DB_DIALECT_MYSQL;
        }
        if ("PostgreSQL".equals(databaseName)) {
            return DBConstants.DB_DIALECT_PGSQL;
        }
        if ("Apache Derby".equals(databaseName)) {
            return DBConstants.DB_DIALECT_DERBY;
        }
        if ("ingres".equalsIgnoreCase(databaseName)) {
            return DBConstants.DB_DIALECT_INGRES;
        }
        if (databaseName.startsWith("Microsoft SQL Server")) {
            return DBConstants.DB_DIALECT_MSSQL;
        }
        if ("Sybase SQL Server".equals(databaseName) || "Adaptive Server Enterprise".equals(databaseName)) {
            return DBConstants.DB_DIALECT_SYBASE;
        }
        if (databaseName.startsWith("Adaptive Server Anywhere")) {
            return DBConstants.DB_DIALECT_SYBASE;
        }
        if (databaseName.startsWith("DB2/")) {
            return DBConstants.DB_DIALECT_DB2;
        }
        if ("Oracle".equals(databaseName)) {
            return DBConstants.DB_DIALECT_ORACLE;
        }
        return DBConstants.DB_DIALECT_GENERIC;
    }
}

