/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.richfaces.component.ColumnGroupingState;
import org.richfaces.component.ColumnsOrder;
import org.richfaces.component.ColumnsSizeState;
import org.richfaces.component.ColumnsVisibility;
import org.richfaces.component.UIExtendedDataTable;
import org.richfaces.json.JSONCollection;
import org.richfaces.json.JSONException;
import org.richfaces.json.JSONMap;
import org.richfaces.json.JSONObject;
import org.richfaces.model.Ordering;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedDataTableState
implements Serializable {
    private static final long serialVersionUID = -3103664821855261335L;
    public static final String NONE_COLUMN_ID = "none";
    protected ColumnsOrder columnsOrder;
    protected ColumnsVisibility columnsVisibility;
    protected ColumnsSizeState columnsSizeState;
    protected ColumnGroupingState columnGroupingState;

    public static ExtendedDataTableState getExtendedDataTableState(UIExtendedDataTable extendedDataTable) {
        ExtendedDataTableState state = new ExtendedDataTableState();
        state.init(extendedDataTable);
        return state;
    }

    protected void init(UIExtendedDataTable extendedDataTable) {
        String value = extendedDataTable.getTableState();
        JSONMap stateMap = null;
        if (value != null && value.length() > 0) {
            try {
                stateMap = new JSONMap(value);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        try {
            this.columnsOrder = ColumnsOrder.getColumnsOrder(extendedDataTable, stateMap == null ? null : (JSONCollection)stateMap.get((Object)"columnsOrder"));
        }
        catch (Exception e) {
            this.columnsOrder = ColumnsOrder.getColumnsOrder(extendedDataTable, (JSONCollection)null);
        }
        try {
            this.columnsVisibility = ColumnsVisibility.getColumnsVisibility(extendedDataTable, stateMap == null ? null : (JSONMap)stateMap.get((Object)"columnsVisibility"));
        }
        catch (Exception e) {
            this.columnsVisibility = ColumnsVisibility.getColumnsVisibility(extendedDataTable, (JSONMap)null);
        }
        try {
            this.columnsSizeState = ColumnsSizeState.getColumnsSize(extendedDataTable, stateMap == null ? null : (JSONMap)stateMap.get((Object)"columnsSizeState"));
        }
        catch (Exception e) {
            this.columnsSizeState = ColumnsSizeState.getColumnsSize(extendedDataTable, null);
        }
        try {
            this.columnGroupingState = ColumnGroupingState.getColumnGropingState(extendedDataTable, stateMap == null ? null : (JSONMap)stateMap.get((Object)"columnGroupingState"));
        }
        catch (Exception e) {
            this.columnGroupingState = ColumnGroupingState.getColumnGropingState(extendedDataTable, null);
        }
    }

    public String toString() {
        return this.toJSON().toString();
    }

    public JSONObject toJSON() {
        JSONObject result = new JSONObject();
        try {
            result.put("columnsOrder", (Object)this.columnsOrder.toJSON());
            result.put("columnsVisibility", (Map)this.columnsVisibility.toJSON());
            result.put("columnsSizeState", (Map)this.columnsSizeState.toJSON());
            result.put("columnGroupingState", (Object)this.columnGroupingState.toJSON());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void changeColumnsOrder(String sourceColumnId, String targetColumnId, boolean dropBefore) {
        this.columnsOrder.changeOrder(sourceColumnId, targetColumnId, dropBefore);
    }

    public List<UIComponent> sortColumns(FacesContext context, List<UIComponent> children) {
        return this.columnsOrder.sortColumns(context, children);
    }

    public boolean isColumnVisible(String columnId) {
        return this.columnsVisibility.isVisible(columnId);
    }

    public void toggleColumnVisibility(UIExtendedDataTable extendedDataTable, String columnId) {
        this.columnsVisibility.toggleVisibility(extendedDataTable, columnId);
    }

    public void changeColumnSize(UIExtendedDataTable extendedDataTable, String newValue) {
        this.columnsSizeState.changeColumnSize(extendedDataTable, newValue);
    }

    public String getColumnSize(UIComponent column) {
        return this.columnsSizeState.getColumnSize(column);
    }

    public String getGroupingColumnId() {
        return this.columnGroupingState.getGroupingColumnId();
    }

    public void groupBy(String colId, Ordering ordering) {
        this.columnGroupingState.groupBy(colId, ordering);
    }

    public void resetGroupVisibilityState() {
        this.columnGroupingState.resetGroupVisibilityState();
    }

    public void disableGrouping() {
        this.columnGroupingState.disableGrouping();
    }

    public boolean groupIsExpanded(int index) {
        return this.columnGroupingState.groupIsExpanded(index);
    }

    public void toggleGroup(int index) {
        this.columnGroupingState.toggleGroup(index);
    }
}

