/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.remoting;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;

class SecurityActions {
    SecurityActions() {
    }

    static SecurityContext createAndSetSecurityContext(final String domain) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<SecurityContext>(){

            @Override
            public SecurityContext run() throws Exception {
                SecurityContext sc = SecurityContextFactory.createSecurityContext((String)domain);
                SecurityActions.setSecurityContext(sc);
                return sc;
            }
        });
    }

    static void setSecurityContext(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    static void setSecurityManagement(final SecurityContext sc, final ISecurityManagement sm) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                sc.setSecurityManagement(sm);
                return null;
            }
        });
    }

    static String trace(final SecurityContext sc) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                StringBuilder sb = new StringBuilder();
                sb.append(" Principal = " + sc.getUtil().getUserPrincipal());
                sb.append(" Subject:" + sc.getUtil().getSubject());
                sb.append(" Incoming run as:" + sc.getIncomingRunAs());
                sb.append(" Outgoing run as:" + sc.getOutgoingRunAs());
                return sb.toString();
            }
        });
    }
}

