/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.connection;

import java.util.Properties;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.profileservice.spi.ProfileService;
import org.rhq.plugins.jbossas5.connection.AbstractProfileServiceConnectionProvider;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnectionImpl;

public class RemoteProfileServiceConnectionProvider
extends AbstractProfileServiceConnectionProvider {
    private static final String NAMING_CONTEXT_FACTORY = "org.jnp.interfaces.NamingContextFactory";
    private static final String JNDI_LOGIN_INITIAL_CONTEXT_FACTORY = "org.jboss.security.jndi.JndiLoginInitialContextFactory";
    private static final String PROFILE_SERVICE_JNDI_NAME = "ProfileService";
    private static final String SECURE_PROFILE_SERVICE_JNDI_NAME = "SecureProfileService/remote";
    private static final String SECURE_MANAGEMENT_VIEW_JNDI_NAME = "SecureManagementView/remote";
    private static final String SECURE_DEPLOYMENT_MANAGER_JNDI_NAME = "SecureDeploymentManager/remote";
    private static final String JNP_DISABLE_DISCOVERY_JNP_INIT_PROP = "jnp.disableDiscovery";
    private static final int JNP_TIMEOUT = 60000;
    private static final int JNP_SO_TIMEOUT = 60000;
    private final Log log = LogFactory.getLog(this.getClass());
    private String providerURL;
    private String principal;
    private String credentials;

    public RemoteProfileServiceConnectionProvider(String providerURL, String principal, String credentials) {
        this.providerURL = providerURL;
        this.principal = principal;
        this.credentials = credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProfileServiceConnectionImpl doConnect() {
        DeploymentManager deploymentManager;
        ManagementView managementView;
        ProfileService profileService;
        Properties env = new Properties();
        env.setProperty("java.naming.provider.url", this.providerURL);
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (this.principal != null) {
                env.setProperty("java.naming.factory.initial", JNDI_LOGIN_INITIAL_CONTEXT_FACTORY);
                env.setProperty("java.naming.security.principal", this.principal);
                env.setProperty("java.naming.security.credentials", this.credentials);
                this.log.debug((Object)("Connecting to Profile Service via remote JNDI using env [" + env + "]..."));
                InitialContext initialContext = this.createInitialContext(env);
                profileService = (ProfileService)this.lookup(initialContext, SECURE_PROFILE_SERVICE_JNDI_NAME);
                managementView = (ManagementView)this.lookup(initialContext, SECURE_MANAGEMENT_VIEW_JNDI_NAME);
                deploymentManager = (DeploymentManager)this.lookup(initialContext, SECURE_DEPLOYMENT_MANAGER_JNDI_NAME);
            } else {
                env.setProperty("java.naming.factory.initial", NAMING_CONTEXT_FACTORY);
                env.setProperty(JNP_DISABLE_DISCOVERY_JNP_INIT_PROP, "true");
                env.setProperty("jnp.timeout", String.valueOf(60000));
                env.setProperty("jnp.sotimeout", String.valueOf(60000));
                this.log.debug((Object)("Connecting to Profile Service via remote JNDI using env [" + env + "]..."));
                InitialContext initialContext = this.createInitialContext(env);
                profileService = (ProfileService)this.lookup(initialContext, PROFILE_SERVICE_JNDI_NAME);
                managementView = profileService.getViewManager();
                deploymentManager = profileService.getDeploymentManager();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
        return new ProfileServiceConnectionImpl(this, profileService, managementView, deploymentManager);
    }

    protected void doDisconnect() {
    }
}

