/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.jasper;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.servlet.ServletContext;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.jasper.xmlparser.TreeNode;
import org.jboss.logging.Logger;

public class TagLibCache
extends TldLocationsCache {
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static final String JAR_FILE_SUFFIX = ".jar";
    private static Logger log = Logger.getLogger(TagLibCache.class);
    private ServletContext ctx;
    private HashMap mappings;
    private ArrayList tagLibJars;

    public TagLibCache(ServletContext ctx, ArrayList tagLibJars) {
        super(ctx, true);
        this.ctx = ctx;
        this.tagLibJars = tagLibJars;
    }

    public String[] getLocation(String uri) throws JasperException {
        if (this.mappings == null) {
            this.init();
        }
        String[] locations = (String[])this.mappings.get(uri);
        return locations;
    }

    private synchronized void init() throws JasperException {
        if (this.mappings != null) {
            return;
        }
        HashMap tmpMappings = null;
        try {
            tmpMappings = new HashMap();
            this.processWebDotXml(tmpMappings);
            this.loadStandardTlds(tmpMappings);
            this.processTldsInFileSystem("/WEB-INF/", tmpMappings);
        }
        catch (Exception ex) {
            String msg = Localizer.getMessage((String)"jsp.error.internal.tldinit", (String)ex.getMessage());
            throw new JasperException(msg, (Throwable)ex);
        }
        finally {
            this.mappings = tmpMappings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processWebDotXml(Map tmpMappings) throws Exception {
        InputStream is = null;
        try {
            String altDDName = (String)this.ctx.getAttribute(Constants.ALT_DD_ATTR);
            if (altDDName != null) {
                try {
                    is = new FileInputStream(altDDName);
                }
                catch (FileNotFoundException e) {
                    log.warn((Object)Localizer.getMessage((String)"jsp.error.internal.filenotfound", (String)altDDName));
                }
            } else {
                is = this.ctx.getResourceAsStream(WEB_XML);
                if (is == null) {
                    log.warn((Object)Localizer.getMessage((String)"jsp.error.internal.filenotfound", (String)WEB_XML));
                }
            }
            if (is == null) {
                return;
            }
            TreeNode webtld = null;
            webtld = altDDName != null ? new ParserUtils().parseXMLDocument(altDDName, is) : new ParserUtils().parseXMLDocument(WEB_XML, is);
            TreeNode jspConfig = webtld.findChild("jsp-config");
            if (jspConfig != null) {
                webtld = jspConfig;
            }
            Iterator taglibs = webtld.findChildren("taglib");
            while (taglibs.hasNext()) {
                TreeNode taglib = (TreeNode)taglibs.next();
                String tagUri = null;
                String tagLoc = null;
                TreeNode child = taglib.findChild("taglib-uri");
                if (child != null) {
                    tagUri = child.getBody();
                }
                if ((child = taglib.findChild("taglib-location")) != null) {
                    tagLoc = child.getBody();
                }
                if (tagLoc == null) continue;
                if (TagLibCache.uriType((String)tagLoc) == 2) {
                    tagLoc = "/WEB-INF/" + tagLoc;
                }
                String tagLoc2 = null;
                if (tagLoc.endsWith(JAR_FILE_SUFFIX)) {
                    tagLoc = this.ctx.getResource(tagLoc).toString();
                    tagLoc2 = "META-INF/taglib.tld";
                }
                tmpMappings.put(tagUri, new String[]{tagLoc, tagLoc2});
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    protected void loadStandardTlds(Map tmpMappings) throws MalformedURLException {
        if (this.tagLibJars.size() == 0) {
            return;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL web = loader.getResource("server.xml");
        URL sarURL = new URL(web, ".");
        for (int n = 0; n < this.tagLibJars.size(); ++n) {
            String jarPath = (String)this.tagLibJars.get(n);
            try {
                URL url = new URL(sarURL, jarPath);
                String resourcePath = url.toString();
                log.debug((Object)("Scanning for tlds in: " + resourcePath));
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                this.scanJar(conn, resourcePath, true, tmpMappings);
                continue;
            }
            catch (Exception e) {
                log.debug((Object)("Failed to scan: " + jarPath), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTldsInFileSystem(String startPath, Map tmpMappings) throws Exception {
        Set dirList = this.ctx.getResourcePaths(startPath);
        if (dirList != null) {
            for (String path : dirList) {
                if (path.endsWith("/")) {
                    this.processTldsInFileSystem(path, tmpMappings);
                }
                if (path.endsWith(JAR_FILE_SUFFIX)) {
                    URL resURL = this.ctx.getResource(path);
                    URLConnection conn = resURL.openConnection();
                    conn.setUseCaches(false);
                    this.scanJar(conn, resURL.toString(), false, tmpMappings);
                    continue;
                }
                if (!path.endsWith(".tld")) continue;
                InputStream stream = this.ctx.getResourceAsStream(path);
                String uri = null;
                try {
                    uri = this.getUriFromTld(path, stream);
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable t) {}
                    }
                }
                if (uri == null || tmpMappings.get(uri) != null) continue;
                tmpMappings.put(uri, new String[]{path, null});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanJar(URLConnection conn, String resourcePath, boolean ignore, Map tmpMappings) throws JasperException, IOException {
        InputStream connIS = conn.getInputStream();
        JarInputStream jis = new JarInputStream(connIS);
        try {
            JarEntry entry = jis.getNextJarEntry();
            while (entry != null) {
                String name = entry.getName();
                if (!name.endsWith(".tld")) {
                    entry = jis.getNextJarEntry();
                    continue;
                }
                EntryInputStream eis = new EntryInputStream(jis);
                String uri = this.getUriFromTld(resourcePath, eis);
                if (uri != null && tmpMappings.get(uri) == null) {
                    tmpMappings.put(uri, new String[]{resourcePath, name});
                }
                entry = jis.getNextJarEntry();
            }
        }
        catch (Exception ex) {
            if (!ignore) {
                throw new JasperException((Throwable)ex);
            }
        }
        finally {
            if (jis != null) {
                try {
                    jis.close();
                }
                catch (Throwable t) {}
            }
            if (connIS != null) {
                try {
                    connIS.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    private String getUriFromTld(String resourcePath, InputStream in) throws JasperException {
        String body;
        TreeNode tld = new ParserUtils().parseXMLDocument(resourcePath, in);
        TreeNode uri = tld.findChild("uri");
        if (uri != null && (body = uri.getBody()) != null) {
            return body;
        }
        return null;
    }

    static class EntryInputStream
    extends InputStream {
        private JarInputStream jis;

        EntryInputStream(JarInputStream jis) {
            this.jis = jis;
        }

        public int read() throws IOException {
            return this.jis.read();
        }

        public int available() throws IOException {
            return this.jis.available();
        }

        public void close() throws IOException {
        }

        public void reset() throws IOException {
            this.jis.reset();
        }

        public boolean markSupported() {
            return this.jis.markSupported();
        }

        public synchronized void mark(int readlimit) {
            this.jis.mark(readlimit);
        }

        public long skip(long n) throws IOException {
            return this.jis.skip(n);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.jis.read(b, off, len);
        }
    }
}

