/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.deployers;

import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.deployers.JBossWebMicrocontainerBeanLocator;

public class MicrocontainerIntegrationLifecycleListener
implements LifecycleListener {
    private static final Logger log = Logger.getLogger(MicrocontainerIntegrationLifecycleListener.class);
    private volatile boolean inited;
    private LifecycleListener delegate;
    private String delegateBeanName;
    private boolean failIfBeanMissing = true;
    private boolean warnIfBeanMissing = true;

    public final String getDelegateBeanName() {
        return this.delegateBeanName;
    }

    public final void setDelegateBeanName(String delegateBeanName) {
        this.delegateBeanName = delegateBeanName;
    }

    public boolean getFailIfBeanMissing() {
        return this.failIfBeanMissing;
    }

    public void setFailIfBeanMissing(boolean failIfBeanMissing) {
        this.failIfBeanMissing = failIfBeanMissing;
    }

    public final boolean getWarnIfBeanMissing() {
        return this.warnIfBeanMissing;
    }

    public final void setWarnIfBeanMissing(boolean warnIfBeanMissing) {
        this.warnIfBeanMissing = warnIfBeanMissing;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if (!this.inited) {
            this.init();
        }
        if (this.delegate != null) {
            this.delegate.lifecycleEvent(event);
        }
    }

    private synchronized void init() {
        if (!this.inited) {
            if (this.delegateBeanName != null) {
                this.delegate = (LifecycleListener)JBossWebMicrocontainerBeanLocator.getInstalledBean(this.delegateBeanName);
            }
            if (this.delegate == null) {
                if (this.failIfBeanMissing) {
                    throw new IllegalStateException("Unable to locate delegate bean " + this.delegateBeanName + "; listener is nonfunctional");
                }
                if (this.warnIfBeanMissing) {
                    log.warn((Object)("Unable to locate delegate bean " + this.delegateBeanName + "; listener is nonfunctional"));
                }
            }
            this.inited = true;
        }
    }
}

