/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.txoj.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Configuration {
    private static final Properties PROPS;
    private static String _lockStore;
    private static String _propFile;

    public static final synchronized String propertiesFile() {
        return _propFile;
    }

    public static final synchronized void setPropertiesFile(String file) {
        _propFile = file;
    }

    public static final synchronized String lockStoreRoot() {
        if (_lockStore == null) {
            _lockStore = System.getProperty("user.dir") + File.separator + "LockStore";
        }
        System.err.println("Returning lockstore location of: " + _lockStore);
        return _lockStore;
    }

    public static final synchronized void setLockStoreRoot(String s) {
        _lockStore = s;
    }

    public static final String version() {
        return Configuration.getBuildTimeProperty("TXOJ_VERSION");
    }

    public static String getBuildTimeProperty(String name) {
        if (PROPS == null) {
            return "";
        }
        return PROPS.getProperty(name, "");
    }

    static {
        InputStream is = Configuration.class.getResourceAsStream("/txoj.properties");
        if (is != null) {
            Properties props = new Properties();
            try {
                props.load(is);
            }
            catch (IOException ioe) {
                props = null;
            }
            PROPS = props;
        } else {
            PROPS = null;
        }
        _lockStore = null;
        _propFile = Configuration.getBuildTimeProperty("PROPERTIES_FILE");
    }
}

