/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config.parsing.element;

import java.util.Properties;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.parsing.XmlConfigHelper;
import org.jboss.cache.config.parsing.XmlParserBase;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LoadersElementParser
extends XmlParserBase {
    public LoadersElementParser() {
        this("urn:jboss:jbosscache-core:config:3.1");
    }

    public LoadersElementParser(String coreNamespace) {
        this.coreNamespace = coreNamespace;
    }

    public CacheLoaderConfig parseLoadersElement(Element element) {
        String preload;
        String shared;
        this.assertNotLegacyElement(element);
        CacheLoaderConfig cacheLoaderConfig = new CacheLoaderConfig();
        String passivation = this.getAttributeValue(element, "passivation");
        if (this.existsAttribute(passivation)) {
            cacheLoaderConfig.setPassivation(this.getBoolean(passivation));
        }
        if (this.existsAttribute(shared = this.getAttributeValue(element, "shared"))) {
            cacheLoaderConfig.setShared(this.getBoolean(shared));
        }
        if ((preload = this.getPreloadString(this.getSingleElementInCoreNS("preload", element))) != null) {
            cacheLoaderConfig.setPreload(preload);
        }
        NodeList cacheLoaderNodes = element.getElementsByTagName("loader");
        for (int i = 0; i < cacheLoaderNodes.getLength(); ++i) {
            Element indivElement = (Element)cacheLoaderNodes.item(i);
            CacheLoaderConfig.IndividualCacheLoaderConfig iclc = this.parseIndividualCacheLoaderConfig(indivElement);
            cacheLoaderConfig.addIndividualCacheLoaderConfig(iclc);
        }
        return cacheLoaderConfig;
    }

    private CacheLoaderConfig.IndividualCacheLoaderConfig parseIndividualCacheLoaderConfig(Element indivElement) {
        String clClass;
        String purgeOnStartup;
        String ignoreModifications;
        String fetchPersistentState;
        CacheLoaderConfig.IndividualCacheLoaderConfig iclc = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        String async = this.getAttributeValue(indivElement, "async");
        if (this.existsAttribute(async)) {
            iclc.setAsync(this.getBoolean(async));
        }
        if (this.existsAttribute(fetchPersistentState = this.getAttributeValue(indivElement, "fetchPersistentState"))) {
            iclc.setFetchPersistentState(this.getBoolean(fetchPersistentState));
        }
        if (this.existsAttribute(ignoreModifications = this.getAttributeValue(indivElement, "ignoreModifications"))) {
            iclc.setIgnoreModifications(this.getBoolean(ignoreModifications));
        }
        if (this.existsAttribute(purgeOnStartup = this.getAttributeValue(indivElement, "purgeOnStartup"))) {
            iclc.setPurgeOnStartup(this.getBoolean(purgeOnStartup));
        }
        if (!this.existsAttribute(clClass = this.getAttributeValue(indivElement, "class"))) {
            throw new ConfigurationException("Missing 'class'  attribute for cache loader configuration");
        }
        iclc.setClassName(clClass);
        iclc.setProperties(XmlConfigHelper.readPropertiesContents(indivElement, "properties"));
        CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig ssc = this.parseSingletonStoreConfig(this.getSingleElementInCoreNS("singletonStore", indivElement));
        if (ssc != null) {
            iclc.setSingletonStoreConfig(ssc);
        }
        return iclc;
    }

    private String getPreloadString(Element preloadElement) {
        if (preloadElement == null) {
            return null;
        }
        NodeList nodesToPreload = preloadElement.getElementsByTagName("node");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < nodesToPreload.getLength(); ++i) {
            Element node = (Element)nodesToPreload.item(i);
            String fqn2preload = this.getAttributeValue(node, "fqn");
            if (!this.existsAttribute(fqn2preload)) {
                throw new ConfigurationException("Missing 'fqn' attribute in 'preload' element");
            }
            if (i > 0) {
                result.append(",");
            }
            result.append(fqn2preload);
        }
        if (nodesToPreload.getLength() == 0) {
            result.append("/");
        }
        return result.toString();
    }

    public CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig parseSingletonStoreConfig(Element element) {
        if (element == null) {
            return null;
        }
        boolean singletonStoreEnabled = this.getBoolean(this.getAttributeValue(element, "enabled"));
        String singletonStoreClass = this.getAttributeValue(element, "class");
        CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig ssc = new CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig();
        if (this.existsAttribute(singletonStoreClass)) {
            ssc.setSingletonStoreClass(singletonStoreClass);
        }
        Properties singletonStoreproperties = XmlConfigHelper.readPropertiesContents(element, "properties");
        ssc.setSingletonStoreEnabled(singletonStoreEnabled);
        ssc.setSingletonStoreClass(singletonStoreClass);
        ssc.setSingletonStoreproperties(singletonStoreproperties);
        return ssc;
    }
}

