/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.util.ZipUtil;
import org.rhq.plugins.jbossas5.util.ResourceTypeUtils;

public class DeploymentUtils {
    private static final Log LOG = LogFactory.getLog(DeploymentUtils.class);

    public static boolean hasCorrectExtension(File archiveFile, ResourceType resourceType) {
        Configuration defaultPluginConfig = ResourceTypeUtils.getDefaultPluginConfiguration(resourceType);
        String expectedExtension = defaultPluginConfig.getSimple("extension").getStringValue();
        if (expectedExtension == null) {
            throw new IllegalStateException("No value was defined for the required 'extension' plugin config prop for " + resourceType);
        }
        String archiveFileName = archiveFile.getName();
        int lastPeriod = archiveFileName.lastIndexOf(".");
        String extension = lastPeriod != -1 ? archiveFileName.substring(lastPeriod + 1) : null;
        return extension != null && new File(extension).equals(new File(expectedExtension));
    }

    public static DeploymentStatus deployArchive(DeploymentManager deploymentManager, File archiveFile, File deployDirectory, boolean deployExploded) throws Exception {
        DeploymentProgress progress;
        if (deployDirectory == null) {
            throw new IllegalArgumentException("Deploy directory is null.");
        }
        String archiveFileName = archiveFile.getName();
        if (deployExploded) {
            LOG.debug((Object)("Deploying '" + archiveFileName + "' in exploded form..."));
            File tempDir = new File(deployDirectory, archiveFile.getName() + ".rej");
            ZipUtil.unzipFile((File)archiveFile, (File)tempDir);
            File archiveDir = new File(deployDirectory, archiveFileName);
            URL contentURL = archiveDir.toURI().toURL();
            if (!tempDir.renameTo(archiveDir)) {
                throw new IOException("Failed to rename '" + tempDir + "' to '" + archiveDir + "'.");
            }
            progress = deploymentManager.distribute(archiveFileName, contentURL, false);
        } else {
            LOG.debug((Object)("Deploying '" + archiveFileName + "' in non-exploded form..."));
            URL contentURL = archiveFile.toURI().toURL();
            File deployLocation = new File(deployDirectory, archiveFileName);
            boolean copyContent = !deployLocation.equals(archiveFile);
            progress = deploymentManager.distribute(archiveFileName, contentURL, copyContent);
        }
        DeploymentStatus distributeStatus = DeploymentUtils.run(progress);
        if (distributeStatus.isFailed()) {
            return distributeStatus;
        }
        String[] deploymentNames = progress.getDeploymentID().getRepositoryNames();
        DeploymentStatus startStatus = DeploymentUtils.run(progress = deploymentManager.start(deploymentNames));
        if (startStatus.isFailed()) {
            LOG.error((Object)("Failed to start deployment " + Arrays.asList(deploymentNames) + " during initial deployment of '" + archiveFileName + "'. Backing out the deployment..."), (Throwable)startStatus.getFailure());
            progress = deploymentManager.remove(deploymentNames);
            DeploymentStatus removeStatus = DeploymentUtils.run(progress);
            if (removeStatus.isFailed()) {
                throw new Exception("Failed to remove deployment " + Arrays.asList(deploymentNames) + " after start failure.", removeStatus.getFailure());
            }
        }
        return startStatus;
    }

    public static DeploymentStatus run(DeploymentProgress progress) throws Exception {
        progress.run();
        return progress.getDeploymentStatus();
    }

    private DeploymentUtils() {
    }
}

