/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.bayeux;

import org.apache.tomcat.bayeux.BayeuxRequest;
import org.apache.tomcat.bayeux.TomcatBayeux;
import org.apache.tomcat.bayeux.request.MetaConnectRequest;
import org.apache.tomcat.bayeux.request.MetaDisconnectRequest;
import org.apache.tomcat.bayeux.request.MetaHandshakeRequest;
import org.apache.tomcat.bayeux.request.MetaSubscribeRequest;
import org.apache.tomcat.bayeux.request.MetaUnsubscribeRequest;
import org.apache.tomcat.bayeux.request.PublishRequest;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.jboss.servlet.http.HttpEvent;

public class RequestFactory {
    public static BayeuxRequest getRequest(TomcatBayeux tomcatBayeux, HttpEvent event, JSONObject msg) throws JSONException {
        String channel = msg.optString("channel");
        if ("/meta/handshake".equals(channel)) {
            return new MetaHandshakeRequest(tomcatBayeux, event, msg);
        }
        if ("/meta/connect".equals(channel)) {
            return new MetaConnectRequest(tomcatBayeux, event, msg);
        }
        if ("/meta/disconnect".equals(channel)) {
            return new MetaDisconnectRequest(tomcatBayeux, event, msg);
        }
        if ("/meta/subscribe".equals(channel)) {
            return new MetaSubscribeRequest(tomcatBayeux, event, msg);
        }
        if ("/meta/unsubscribe".equals(channel)) {
            return new MetaUnsubscribeRequest(tomcatBayeux, event, msg);
        }
        return new PublishRequest(tomcatBayeux, event, msg);
    }
}

