/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.provider.JAXBContextResolver;
import org.exoplatform.services.rest.provider.EntityProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"application/xml", "text/xml", "application/xhtml+xml"})
@Produces(value={"application/xml", "text/xml", "application/xhtml+xml"})
public class JAXBElementEntityProvider
implements EntityProvider<JAXBElement<?>> {
    private static final Log LOG = ExoLogger.getLogger((String)JAXBElementEntityProvider.class.getName());
    @Context
    private Providers providers;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == JAXBElement.class && genericType instanceof ParameterizedType;
    }

    public JAXBElement<?> readFrom(Class<JAXBElement<?>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        ParameterizedType pt = (ParameterizedType)genericType;
        Class c = (Class)pt.getActualTypeArguments()[0];
        try {
            JAXBContext jaxbctx = this.getJAXBContext(c, mediaType);
            return jaxbctx.createUnmarshaller().unmarshal((Source)new StreamSource(entityStream), c);
        }
        catch (UnmarshalException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
        catch (JAXBException e) {
            throw new IOException("Can't read from input stream " + (Object)((Object)e));
        }
    }

    public long getSize(JAXBElement<?> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JAXBElement.class.isAssignableFrom(type);
    }

    public void writeTo(JAXBElement<?> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        Class c = t.getDeclaredType();
        try {
            JAXBContext jaxbctx = this.getJAXBContext(c, mediaType);
            Marshaller m = jaxbctx.createMarshaller();
            String charset = (String)mediaType.getParameters().get("charset");
            if (charset != null) {
                m.setProperty("jaxb.encoding", (Object)charset);
            }
            m.marshal(t, entityStream);
        }
        catch (JAXBException e) {
            throw new IOException("Can't write to output stream " + (Object)((Object)e));
        }
    }

    protected JAXBContext getJAXBContext(Class<?> type, MediaType mediaType) throws JAXBException {
        ContextResolver resolver = this.providers.getContextResolver(JAXBContextResolver.class, mediaType);
        if (resolver == null) {
            throw new RuntimeException("Not found any JAXBContextResolver for media type " + mediaType);
        }
        JAXBContextResolver jaxbres = (JAXBContextResolver)resolver.getContext(type);
        return jaxbres.getJAXBContext(type);
    }
}

