/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.configuration;

import java.util.HashSet;
import java.util.Set;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

class NoKernelNamespaceSAXFilter
extends DefaultHandler {
    private static final Log log = ExoLogger.getExoLogger(NoKernelNamespaceSAXFilter.class);
    private static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private ContentHandler contentHandler;
    private final Set<String> blackListedPrefixes;

    NoKernelNamespaceSAXFilter(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        this.blackListedPrefixes = new HashSet<String>();
    }

    public void setDocumentLocator(Locator locator) {
        this.contentHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if ("http://www.exoplaform.org/xml/ns/kernel_1_0.xsd".equals(uri) || "http://www.exoplaform.org/xml/ns/kernel_1_1.xsd".equals(uri) || XSI_URI.equals(uri)) {
            this.blackListedPrefixes.add(prefix);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Black listing prefix " + prefix + " with uri " + uri));
            }
        } else {
            this.contentHandler.startPrefixMapping(prefix, uri);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Start prefix mapping " + prefix + " with uri " + uri));
            }
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (!this.blackListedPrefixes.remove(prefix)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Ending prefix mapping " + prefix));
            }
            this.contentHandler.endPrefixMapping(prefix);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("Removed prefix mapping " + prefix + " from black list "));
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        AttributesImpl noNSAtts = new AttributesImpl();
        for (int i = 0; i < atts.getLength(); ++i) {
            String attQName = atts.getQName(i);
            if (attQName.equals("xmlns") && this.blackListedPrefixes.contains("")) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)"Skipping black listed xmlns attribute");
                continue;
            }
            if (attQName.startsWith("xmlns:") && this.blackListedPrefixes.contains(attQName.substring(6))) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Skipping black listed " + attQName + " attribute"));
                continue;
            }
            String attURI = atts.getURI(i);
            String attLocalName = atts.getLocalName(i);
            String attType = atts.getType(i);
            String attValue = atts.getValue(i);
            if (XSI_URI.equals(attURI)) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Skipping XSI " + attQName + " attribute"));
                continue;
            }
            if ("http://www.exoplaform.org/xml/ns/kernel_1_0.xsd".equals(attURI) || "http://www.exoplaform.org/xml/ns/kernel_1_1.xsd".equals(attURI)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Requalifying prefixed attribute " + attQName + " attribute to " + localName));
                }
                attURI = null;
                attQName = localName;
            }
            noNSAtts.addAttribute(attURI, attLocalName, attQName, attType, attValue);
        }
        if ("http://www.exoplaform.org/xml/ns/kernel_1_0.xsd".equals(uri) || "http://www.exoplaform.org/xml/ns/kernel_1_1.xsd".equals(uri)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Requalifying active profile " + qName + " start element to " + localName));
            }
            qName = localName;
            uri = null;
        }
        this.contentHandler.startElement(uri, localName, qName, noNSAtts);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("http://www.exoplaform.org/xml/ns/kernel_1_0.xsd".equals(uri) || "http://www.exoplaform.org/xml/ns/kernel_1_1.xsd".equals(uri)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Requalifying " + qName + " end element"));
            }
            qName = localName;
            uri = null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Propagatting " + qName + " end element"));
        }
        this.contentHandler.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.contentHandler.skippedEntity(name);
    }
}

